/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.object.query;

import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.id.LogicalType;
import org.apache.isis.commons.functional.Result;
import org.apache.isis.commons.internal.context._Context;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.specloader.SpecificationLoader;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.metamodel.facets.object.query.JdoQueryAnnotationFacetFactory;
import org.apache.isis.persistence.jdo.metamodel.facets.object.query.MetaModelVisitingValidatorForClauseAbstract;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;

class MetaModelVisitingValidatorForVariablesClause
extends MetaModelVisitingValidatorForClauseAbstract {
    MetaModelVisitingValidatorForVariablesClause(MetaModelContext mmc) {
        super(mmc, "VARIABLES");
    }

    @Override
    String deriveClause(String query) {
        return JdoQueryAnnotationFacetFactory.variables(query);
    }

    @Override
    void postInterpretJdoql(String classNameFromClause, ObjectSpecification objectSpec, String query) {
        JdoPersistenceCapableFacet persistenceCapableFacet = Result.of(() -> this.getSpecificationLoader().specForType(_Context.loadClass((String)classNameFromClause)).map(spec -> (JdoPersistenceCapableFacet)spec.getFacet(JdoPersistenceCapableFacet.class)).orElse(null)).getValue().orElse(null);
        if (persistenceCapableFacet == null) {
            Class cls = objectSpec.getCorrespondingClass();
            ValidationFailure.raise((SpecificationLoader)objectSpec.getSpecificationLoader(), (Identifier)Identifier.classIdentifier((LogicalType)LogicalType.fqcn((Class)cls)), (String)String.format("%s: error in JDOQL query, class name for '%s' clause is not annotated as @PersistenceCapable (JDOQL : %s)", cls.getName(), this.clause, query));
            return;
        }
    }
}

