/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.prop.column;

import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.digits.MaxFractionalDigitsFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.digits.MaxTotalDigitsFacet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.column.MaxFractionalDigitsFacetFromJdoColumn;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.column.MaxTotalDigitsFacetFromJdoColumnAnnotation;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class BigDecimalFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    @Inject
    public BigDecimalFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        if (BigDecimal.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        Optional jdoColumnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        this.addFacetIfPresent(MaxTotalDigitsFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)holder));
        this.addFacetIfPresent(MaxFractionalDigitsFacetFromJdoColumn.create(jdoColumnIfAny, (FacetHolder)holder));
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addVisitingValidatorSkipManagedBeans(spec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)spec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            spec.streamProperties(MixedIn.EXCLUDED).filter(association -> !association.containsNonFallbackFacet(JdoNotPersistentFacet.class)).forEach(association -> BigDecimalFromJdoColumnAnnotationFacetFactory.validateBigDecimalValueFacet((ObjectAssociation)association));
        }, new ProgrammingModel.Marker[0]);
    }

    private static void validateBigDecimalValueFacet(ObjectAssociation association) {
        association.lookupFacet(MaxTotalDigitsFacet.class).map(Facet::getSharedFacetRankingElseFail).ifPresent(facetRanking -> facetRanking.visitTopRankPairsSemanticDiffering(MaxTotalDigitsFacet.class, (a, b) -> ValidationFailure.raiseFormatted((FacetHolder)association, (String)"%s: inconsistent MaxTotalDigits semantics specified in %s and %s.", (Object[])new Object[]{association.getFeatureIdentifier().toString(), a.getClass().getSimpleName(), b.getClass().getSimpleName()})));
        association.lookupFacet(MaxFractionalDigitsFacet.class).map(Facet::getSharedFacetRankingElseFail).ifPresent(facetRanking -> facetRanking.visitTopRankPairsSemanticDiffering(MaxFractionalDigitsFacet.class, (a, b) -> ValidationFailure.raiseFormatted((FacetHolder)association, (String)"%s: inconsistent MaxFractionalDigits semantics specified in %s and %s.", (Object[])new Object[]{association.getFeatureIdentifier().toString(), a.getClass().getSimpleName(), b.getClass().getSimpleName()})));
    }
}

