/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.prop.column;

import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.mandatory.MandatoryFacet;
import org.apache.isis.core.metamodel.facets.properties.property.mandatory.MandatoryFacetForPropertyAnnotation;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.column.MandatoryFacetFromAbsenceOfJdoColumnAnnotation;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.column.MandatoryFacetFromJdoColumnAnnotation;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.primarykey.OptionalFacetFromJdoPrimaryKeyAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class MandatoryFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public MandatoryFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        FacetedMethod holder = (FacetedMethod)processMethodContext.getFacetHolder();
        MandatoryFacet existingFacet = (MandatoryFacet)holder.getFacet(MandatoryFacet.class);
        if (existingFacet != null) {
            if (existingFacet instanceof OptionalFacetFromJdoPrimaryKeyAnnotation) {
                return;
            }
            if (existingFacet instanceof MandatoryFacetForPropertyAnnotation.Required) {
                return;
            }
        }
        Optional columnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        MandatoryFacet.Semantics semantics = MandatoryFromJdoColumnAnnotationFacetFactory.inferSemantics(processMethodContext, columnIfAny);
        FacetUtil.addFacet((Facet)(columnIfAny.isPresent() ? new MandatoryFacetFromJdoColumnAnnotation((FacetHolder)holder, semantics) : new MandatoryFacetFromAbsenceOfJdoColumnAnnotation((FacetHolder)holder, semantics, semantics.isRequired() ? Facet.Precedence.DEFAULT : Facet.Precedence.INFERRED)));
    }

    private static MandatoryFacet.Semantics inferSemantics(FacetFactory.ProcessMethodContext processMethodContext, Optional<Column> columnIfAny) {
        String allowsNull;
        String string = allowsNull = columnIfAny.isPresent() ? columnIfAny.get().allowsNull() : null;
        if (_Strings.isNotEmpty((CharSequence)allowsNull)) {
            return MandatoryFacet.Semantics.of((!"true".equalsIgnoreCase(allowsNull.trim()) ? 1 : 0) != 0);
        }
        Class<?> returnType = processMethodContext.getMethod().getReturnType();
        return returnType != null && returnType.isPrimitive() ? MandatoryFacet.Semantics.REQUIRED : MandatoryFacet.Semantics.OPTIONAL;
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addVisitingValidatorSkipManagedBeans(objectSpec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)objectSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            Stream<ObjectAssociation> associations = objectSpec.streamAssociations(MixedIn.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
            associations.filter(association -> !association.containsNonFallbackFacet(JdoNotPersistentFacet.class)).forEach(association -> MandatoryFromJdoColumnAnnotationFacetFactory.validateMandatoryFacet(association));
        }, new ProgrammingModel.Marker[0]);
    }

    private static void validateMandatoryFacet(ObjectAssociation association) {
        association.lookupFacet(MandatoryFacet.class).map(Facet::getSharedFacetRankingElseFail).ifPresent(facetRanking -> facetRanking.visitTopRankPairsSemanticDiffering(MandatoryFacet.class, (a, b) -> ValidationFailure.raiseFormatted((FacetHolder)association, (String)"%s: inconsistent Mandatory/Optional semantics specified in %s and %s.", (Object[])new Object[]{association.getFeatureIdentifier().toString(), a.getClass().getSimpleName(), b.getClass().getSimpleName()})));
    }
}

