/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.prop.column;

import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.jdo.annotations.Column;
import javax.jdo.annotations.IdentityType;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FacetUtil;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facetapi.MetaModelRefiner;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.core.metamodel.facets.objectvalue.maxlen.MaxLengthFacet;
import org.apache.isis.core.metamodel.progmodel.ProgrammingModel;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;
import org.apache.isis.core.metamodel.specloader.validator.ValidationFailure;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.column.MaxTotalDigitsFacetFromJdoColumnAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.object.persistencecapable.JdoPersistenceCapableFacet;
import org.apache.isis.persistence.jdo.provider.metamodel.facets.prop.notpersistent.JdoNotPersistentFacet;

public class MaxLengthFromJdoColumnAnnotationFacetFactory
extends FacetFactoryAbstract
implements MetaModelRefiner {
    @Inject
    private JdoFacetContext jdoFacetContext;

    public MaxLengthFromJdoColumnAnnotationFacetFactory(MetaModelContext mmc) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        if (String.class != processMethodContext.getMethod().getReturnType()) {
            return;
        }
        Optional jdoColumnIfAny = processMethodContext.synthesizeOnMethod(Column.class);
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        FacetUtil.addFacetIfPresent(MaxTotalDigitsFacetFromJdoColumnAnnotation.create(jdoColumnIfAny, (FacetHolder)facetHolder));
    }

    public void refineProgrammingModel(ProgrammingModel programmingModel) {
        programmingModel.addVisitingValidatorSkipManagedBeans(objectSpec -> {
            JdoPersistenceCapableFacet pcFacet = (JdoPersistenceCapableFacet)objectSpec.getFacet(JdoPersistenceCapableFacet.class);
            if (pcFacet == null || pcFacet.getIdentityType() == IdentityType.NONDURABLE) {
                return;
            }
            Stream<ObjectAssociation> associations = objectSpec.streamAssociations(MixedIn.EXCLUDED).filter(ObjectAssociation.Predicates.PROPERTIES);
            associations.forEach(association -> {
                if (association.containsNonFallbackFacet(JdoNotPersistentFacet.class)) {
                    return;
                }
                association.lookupFacet(MaxLengthFacet.class).map(Facet::getSharedFacetRankingElseFail).ifPresent(facetRanking -> facetRanking.visitTopRankPairsSemanticDiffering(MaxLengthFacet.class, (a, b) -> ValidationFailure.raiseFormatted((FacetHolder)association, (String)"%s: inconsistent MaxLength semantics specified in %s and %s.", (Object[])new Object[]{association.getFeatureIdentifier().toString(), a.getClass().getSimpleName(), b.getClass().getSimpleName()})));
            });
        }, new ProgrammingModel.Marker[0]);
    }
}

