/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.facets.prop.primarykey;

import java.util.Optional;
import javax.inject.Inject;
import javax.jdo.annotations.PrimaryKey;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.facetapi.FacetHolder;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.FacetFactory;
import org.apache.isis.core.metamodel.facets.FacetFactoryAbstract;
import org.apache.isis.core.metamodel.facets.FacetedMethod;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.primarykey.DisabledFacetFromJdoPrimaryKeyAnnotation;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.primarykey.JdoPrimaryKeyFacetAnnotation;
import org.apache.isis.persistence.jdo.metamodel.facets.prop.primarykey.OptionalFacetFromJdoPrimaryKeyAnnotation;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;

public class JdoPrimaryKeyAnnotationFacetFactory
extends FacetFactoryAbstract {
    private final JdoFacetContext jdoFacetContext;

    @Inject
    public JdoPrimaryKeyAnnotationFacetFactory(MetaModelContext mmc, JdoFacetContext jdoFacetContext) {
        super(mmc, FeatureType.PROPERTIES_ONLY);
        this.jdoFacetContext = jdoFacetContext;
    }

    public void process(FacetFactory.ProcessMethodContext processMethodContext) {
        Class cls = processMethodContext.getCls();
        if (!this.jdoFacetContext.isPersistenceEnhanced(cls)) {
            return;
        }
        Optional primaryKeyIfAny = processMethodContext.synthesizeOnMethod(PrimaryKey.class);
        if (!primaryKeyIfAny.isPresent()) {
            return;
        }
        FacetedMethod facetHolder = (FacetedMethod)processMethodContext.getFacetHolder();
        this.addFacet((Facet)new JdoPrimaryKeyFacetAnnotation((FacetHolder)facetHolder));
        this.addFacet((Facet)new OptionalFacetFromJdoPrimaryKeyAnnotation((FacetHolder)facetHolder));
        this.addFacet((Facet)new DisabledFacetFromJdoPrimaryKeyAnnotation((FacetHolder)facetHolder));
    }
}

