/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.metamodel.menu;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import javax.jdo.PersistenceManagerFactory;
import javax.jdo.metadata.TypeMetadata;
import org.apache.isis.applib.IsisModuleApplib;
import org.apache.isis.applib.annotation.Action;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.DomainService;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.annotation.MemberSupport;
import org.apache.isis.applib.annotation.RestrictTo;
import org.apache.isis.applib.annotation.SemanticsOf;
import org.apache.isis.applib.util.ZipWriter;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.applib.value.NamedWithMimeType;
import org.apache.isis.persistence.jdo.applib.services.JdoSupportService;
import org.apache.isis.persistence.jdo.provider.entities.JdoFacetContext;

@DomainService(logicalTypeName="isis.persistence.jdo.JdoMetamodelMenu")
@DomainServiceLayout(menuBar=DomainServiceLayout.MenuBar.SECONDARY, named="Prototyping")
@Named(value="isis.persistence.jdo.JdoMetamodelMenu")
@Priority(value=0x1FFFFFFF)
public class JdoMetamodelMenu {
    public static final String LOGICAL_TYPE_NAME = "isis.persistence.jdo.JdoMetamodelMenu";
    final JdoSupportService jdoSupport;
    final JdoFacetContext jdoFacetContext;

    private byte[] zip() {
        PersistenceManagerFactory pmFactory = this.getPersistenceManagerFactory();
        ZipWriter zipWriter = ZipWriter.ofFailureMessage((String)"Unable to create zip of jdo metamodels");
        pmFactory.getManagedClasses().stream().filter(arg_0 -> ((JdoFacetContext)this.jdoFacetContext).isPersistenceEnhanced(arg_0)).map(Class::getName).map(arg_0 -> ((PersistenceManagerFactory)pmFactory).getMetadata(arg_0)).forEach(metadata -> {
            String xmlString = metadata.toString();
            zipWriter.nextEntry(this.zipEntryNameFor((TypeMetadata)metadata), writer -> writer.writeCharactersUtf8((CharSequence)xmlString));
        });
        return zipWriter.toBytes();
    }

    private String zipEntryNameFor(TypeMetadata metadata) {
        return metadata.getName() + ".xml";
    }

    private PersistenceManagerFactory getPersistenceManagerFactory() {
        return this.jdoSupport.getPersistenceManager().getPersistenceManagerFactory();
    }

    @Inject
    public JdoMetamodelMenu(JdoSupportService jdoSupport, JdoFacetContext jdoFacetContext) {
        this.jdoSupport = jdoSupport;
        this.jdoFacetContext = jdoFacetContext;
    }

    @Action(domainEvent=ActionEvent.class, semantics=SemanticsOf.NON_IDEMPOTENT, restrictTo=RestrictTo.PROTOTYPING)
    @ActionLayout(cssClassFa="fa-download", named="Download JDO Metamodels (ZIP)", sequence="500.670.1")
    public class downloadMetamodels {
        @MemberSupport
        public Blob act() {
            byte[] zipBytes = JdoMetamodelMenu.this.zip();
            return Blob.of((String)"jdo-metamodels", (NamedWithMimeType.CommonMimeType)NamedWithMimeType.CommonMimeType.ZIP, (byte[])zipBytes);
        }

        public class ActionEvent
        extends ActionDomainEvent<downloadMetamodels> {
        }
    }

    public static abstract class ActionDomainEvent<T>
    extends IsisModuleApplib.ActionDomainEvent<T> {
    }
}

