/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.provider.metamodel.facets.object.query;

import javax.jdo.annotations.Query;
import lombok.NonNull;
import org.apache.isis.core.metamodel.services.metamodel.MetaModelExportSupport;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.springframework.lang.Nullable;

public final class JdoNamedQuery
implements MetaModelExportSupport {
    @NonNull
    private final String name;
    @NonNull
    private final String query;
    @Nullable
    private final String language;
    @NonNull
    private final ObjectSpecification objectSpecification;

    public JdoNamedQuery(Query jdoNamedQuery, ObjectSpecification objSpec) {
        this(jdoNamedQuery.name(), jdoNamedQuery.value(), jdoNamedQuery.language(), objSpec);
    }

    public String toMetamodelString() {
        return this.getName();
    }

    @NonNull
    public String getName() {
        return this.name;
    }

    @NonNull
    public String getQuery() {
        return this.query;
    }

    @Nullable
    public String getLanguage() {
        return this.language;
    }

    @NonNull
    public ObjectSpecification getObjectSpecification() {
        return this.objectSpecification;
    }

    private JdoNamedQuery(@NonNull String name, @NonNull String query, @Nullable String language, @NonNull ObjectSpecification objectSpecification) {
        if (name == null) {
            throw new NullPointerException("name is marked non-null but is null");
        }
        if (query == null) {
            throw new NullPointerException("query is marked non-null but is null");
        }
        if (objectSpecification == null) {
            throw new NullPointerException("objectSpecification is marked non-null but is null");
        }
        this.name = name;
        this.query = query;
        this.language = language;
        this.objectSpecification = objectSpecification;
    }

    public String toString() {
        return "JdoNamedQuery(name=" + this.getName() + ", query=" + this.getQuery() + ", language=" + this.getLanguage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JdoNamedQuery)) {
            return false;
        }
        JdoNamedQuery other = (JdoNamedQuery)o;
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$query = this.getQuery();
        String other$query = other.getQuery();
        if (this$query == null ? other$query != null : !this$query.equals(other$query)) {
            return false;
        }
        String this$language = this.getLanguage();
        String other$language = other.getLanguage();
        return !(this$language == null ? other$language != null : !this$language.equals(other$language));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $query = this.getQuery();
        result = result * 59 + ($query == null ? 43 : $query.hashCode());
        String $language = this.getLanguage();
        result = result * 59 + ($language == null ? 43 : $language.hashCode());
        return result;
    }
}

