/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.persistence.jdo.spring.exceptions;

import org.springframework.dao.OptimisticLockingFailureException;

public class ObjectOptimisticLockingFailureException
extends OptimisticLockingFailureException {
    private Object persistentClass;
    private Object identifier;

    public ObjectOptimisticLockingFailureException(String msg, Throwable cause) {
        super(msg, cause);
    }

    public ObjectOptimisticLockingFailureException(Class<?> persistentClass, Object identifier) {
        this(persistentClass, identifier, null);
    }

    public ObjectOptimisticLockingFailureException(Class<?> persistentClass, Object identifier, Throwable cause) {
        this(persistentClass, identifier, "Object of class [" + persistentClass.getName() + "] with identifier [" + identifier + "]: optimistic locking failed", cause);
    }

    public ObjectOptimisticLockingFailureException(Class<?> persistentClass, Object identifier, String msg, Throwable cause) {
        super(msg, cause);
        this.persistentClass = persistentClass;
        this.identifier = identifier;
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier) {
        this(persistentClassName, identifier, null);
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier, Throwable cause) {
        this(persistentClassName, identifier, "Object of class [" + persistentClassName + "] with identifier [" + identifier + "]: optimistic locking failed", cause);
    }

    public ObjectOptimisticLockingFailureException(String persistentClassName, Object identifier, String msg, Throwable cause) {
        super(msg, cause);
        this.persistentClass = persistentClassName;
        this.identifier = identifier;
    }

    public Class<?> getPersistentClass() {
        return this.persistentClass instanceof Class ? (Class)this.persistentClass : null;
    }

    public String getPersistentClassName() {
        if (this.persistentClass instanceof Class) {
            return ((Class)this.persistentClass).getName();
        }
        return this.persistentClass != null ? this.persistentClass.toString() : null;
    }

    public Object getIdentifier() {
        return this.identifier;
    }
}

