/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.subdomains.spring.applib.service;

import java.util.Arrays;
import java.util.Collections;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.isis.subdomains.spring.applib.service.BeanDescriptor;
import org.apache.isis.subdomains.spring.applib.service.SpringBeansService;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.context.ConfigurableApplicationContext;

public final class ContextBeans {
    private final Map<String, BeanDescriptor> beans;
    private final String parentId;
    private final ConfigurableApplicationContext context;

    static ContextBeans describing(ConfigurableApplicationContext context) {
        if (context == null) {
            return null;
        }
        ConfigurableApplicationContext parent = SpringBeansService.Util.getConfigurableParent(context);
        Map<String, BeanDescriptor> beans = ContextBeans.describeBeans(context);
        String parentId = parent != null ? parent.getId() : null;
        return new ContextBeans(beans, parentId, context);
    }

    private static Map<String, BeanDescriptor> describeBeans(ConfigurableApplicationContext context) {
        ConfigurableListableBeanFactory beanFactory = context.getBeanFactory();
        Map beans = Arrays.stream(beanFactory.getBeanDefinitionNames()).filter(beanName -> ContextBeans.isBeanEligible(beanName, beanFactory)).collect(Collectors.toMap(Function.identity(), beanName -> new BeanDescriptor((String)beanName, context)));
        return Collections.unmodifiableMap(beans);
    }

    private static boolean isBeanEligible(String beanName, ConfigurableListableBeanFactory bf) {
        BeanDefinition bd = bf.getBeanDefinition(beanName);
        return bd.getRole() != 2 && (!bd.isLazyInit() || bf.containsSingleton(beanName));
    }

    public ContextBeans(Map<String, BeanDescriptor> beans, String parentId, ConfigurableApplicationContext context) {
        this.beans = beans;
        this.parentId = parentId;
        this.context = context;
    }

    public Map<String, BeanDescriptor> getBeans() {
        return this.beans;
    }

    public String getParentId() {
        return this.parentId;
    }

    public ConfigurableApplicationContext getContext() {
        return this.context;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ContextBeans)) {
            return false;
        }
        ContextBeans other = (ContextBeans)o;
        Map<String, BeanDescriptor> this$beans = this.getBeans();
        Map<String, BeanDescriptor> other$beans = other.getBeans();
        if (this$beans == null ? other$beans != null : !((Object)this$beans).equals(other$beans)) {
            return false;
        }
        String this$parentId = this.getParentId();
        String other$parentId = other.getParentId();
        if (this$parentId == null ? other$parentId != null : !this$parentId.equals(other$parentId)) {
            return false;
        }
        ConfigurableApplicationContext this$context = this.getContext();
        ConfigurableApplicationContext other$context = other.getContext();
        return !(this$context == null ? other$context != null : !this$context.equals(other$context));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Map<String, BeanDescriptor> $beans = this.getBeans();
        result = result * 59 + ($beans == null ? 43 : ((Object)$beans).hashCode());
        String $parentId = this.getParentId();
        result = result * 59 + ($parentId == null ? 43 : $parentId.hashCode());
        ConfigurableApplicationContext $context = this.getContext();
        result = result * 59 + ($context == null ? 43 : $context.hashCode());
        return result;
    }

    public String toString() {
        return "ContextBeans(beans=" + this.getBeans() + ", parentId=" + this.getParentId() + ", context=" + this.getContext() + ")";
    }
}

