/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.subdomains.spring.applib.service;

import java.util.HashMap;
import java.util.Map;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.subdomains.spring.applib.service.ContextBeans;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.sub.spring.SpringBeansService")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class SpringBeansService {
    private final ConfigurableApplicationContext context;

    @Inject
    public SpringBeansService(ConfigurableApplicationContext context) {
        this.context = context;
    }

    public Map<String, ContextBeans> beans() {
        HashMap<String, ContextBeans> contexts = new HashMap<String, ContextBeans>();
        ConfigurableApplicationContext context = this.context;
        while (context != null) {
            contexts.put(context.getId(), ContextBeans.describing(context));
            context = Util.getConfigurableParent(context);
        }
        return contexts;
    }

    static final class Util {
        static ConfigurableApplicationContext getConfigurableParent(ConfigurableApplicationContext context) {
            ApplicationContext parent = context.getParent();
            return parent instanceof ConfigurableApplicationContext ? (ConfigurableApplicationContext)parent : null;
        }

        private Util() {
            throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
        }
    }
}

