/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.function.Predicate;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;

public class Collections
extends AbstractRandomValueGenerator {
    public Collections(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public <E extends Enum<E>> E anyEnum(Class<E> enumType) {
        Enum[] enumConstants = (Enum[])enumType.getEnumConstants();
        return (E)enumConstants[this.fake.ints().upTo(enumConstants.length)];
    }

    public <E extends Enum<E>> E anyEnumExcept(Class<E> enumType, Predicate<E> except) {
        return (E)Collections.find(() -> this.anyEnum(enumType), except);
    }

    public <T> T anyBounded(Class<T> cls) {
        List list = this.fake.repositoryService.allInstances(cls);
        return this.anyOf(list);
    }

    public <T> T anyBoundedExcept(Class<T> cls, Predicate<T> except) {
        List list = this.fake.repositoryService.allInstances(cls);
        return this.anyOfExcept(list, except);
    }

    public <T> T anyOf(List<T> list) {
        int randomIdx = this.fake.ints().upTo(list.size());
        return list.get(randomIdx);
    }

    public <T> T anyOf(Collection<T> collection) {
        int randomIdx = this.fake.ints().upTo(collection.size());
        int i = 0;
        for (T element : collection) {
            if (randomIdx != i++) continue;
            return element;
        }
        throw new RuntimeException("failed to obtain random element from collection - most likely a bug in the FakeData service itself");
    }

    public <T> T anyOfExcept(List<T> list, Predicate<T> except) {
        return (T)Collections.find(() -> this.anyOf(list), except);
    }

    public <T> T anyOfExcept(Collection<T> collection, Predicate<T> except) {
        return (T)Collections.find(() -> this.anyOf(collection), except);
    }

    public char anyOf(char ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public char anyOfExcept(char[] elements, Predicate<Character> except) {
        return Collections.find(() -> Character.valueOf(this.anyOf(elements)), except).charValue();
    }

    public byte anyOf(byte ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public byte anyOfExcept(byte[] elements, Predicate<Byte> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public short anyOf(short ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public short anyOfExcept(short[] elements, Predicate<Short> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public int anyOf(int ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public int anyOfExcept(int[] elements, Predicate<Integer> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public long anyOf(long ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    @Programmatic
    public long anyOfExcept(long[] elements, Predicate<Long> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public float anyOf(float ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public float anyOfExcept(float[] elements, Predicate<Float> except) {
        return Collections.find(() -> Float.valueOf(this.anyOf(elements)), except).floatValue();
    }

    public double anyOf(double ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public double anyOfExcept(double[] elements, Predicate<Double> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public boolean anyOf(boolean ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public boolean anyOfExcept(boolean[] elements, Predicate<Boolean> except) {
        return Collections.find(() -> this.anyOf(elements), except);
    }

    public <T> T anyOf(T ... elements) {
        int randomIdx = this.fake.ints().upTo(elements.length);
        return elements[randomIdx];
    }

    public <T> T anyOfExcept(T[] elements, Predicate<T> except) {
        return (T)Collections.find(() -> this.anyOf(elements), except);
    }

    static <E> E find(Callable<E> block, Predicate<E> except) {
        for (int i = 0; i < 100; ++i) {
            E e;
            try {
                e = block.call();
            }
            catch (Exception e1) {
                throw new RuntimeException("Problem finding candidate values");
            }
            if (except.test(e)) continue;
            return e;
        }
        throw new RuntimeException("Failed to find a random element in collection");
    }
}

