/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.value.Blob;
import org.apache.isis.commons.internal.base._Bytes;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;

public class IsisBlobs
extends AbstractRandomValueGenerator {
    private static final List<String> fileNames = Arrays.asList("image01-150x150.jpg", "image01-240x180.jpg", "image01-640x480.jpg", "image01-2048x1536.jpg", "image01-4000x3000.jpg", "image02-150x150.jpg", "image02-240x180.jpg", "image02-640x480.jpg", "image02-2048x1536.jpg", "image02-4000x3000.jpg", "Pawson-Naked-Objects-thesis.pdf", "rick-mugridge-paper.pdf");

    public IsisBlobs(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public Blob any() {
        List<String> fileNames = IsisBlobs.fileNames;
        return this.asBlob(fileNames);
    }

    public Blob anyJpg() {
        return this.asBlob(IsisBlobs.fileNamesEndingWith(".jpg"));
    }

    public Blob anyPdf() {
        return this.asBlob(IsisBlobs.fileNamesEndingWith(".pdf"));
    }

    private Blob asBlob(List<String> fileNames) {
        int randomIdx = this.fake.ints().upTo(fileNames.size());
        String randomFileName = fileNames.get(randomIdx);
        return IsisBlobs.asBlob(randomFileName);
    }

    private static List<String> fileNamesEndingWith(String suffix) {
        return fileNames.stream().filter(input -> input.endsWith(suffix)).collect(Collectors.toList());
    }

    private static Blob asBlob(String fileName) {
        Blob blob;
        block8: {
            InputStream is = _Resources.load(IsisBlobs.class, (String)("blobs/" + fileName));
            try {
                blob = new Blob(fileName, IsisBlobs.mimeTypeFor(fileName), _Bytes.of((InputStream)is));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return blob;
    }

    private static String mimeTypeFor(String fileName) {
        if (fileName.endsWith("jpg")) {
            return "image/jpeg";
        }
        return "application/pdf";
    }
}

