/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.applib.value.Clob;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.resources._Resources;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;
import org.apache.isis.testing.fakedata.applib.services.IsisBlobs;

public class IsisClobs
extends AbstractRandomValueGenerator {
    private static final List<String> fileNames = Arrays.asList("a_and_c.xml", "all_well.xml", "as_you.xml", "com_err.xml", "coriolan.xml", "cymbelin.xml", "dream.xml", "hamlet.xml", "hen_iv_1.xml", "hen_iv_2.xml", "hen_v.xml", "hen_vi_1.xml", "hen_vi_2.xml", "hen_vi_3.xml", "hen_viii.xml", "j_caesar.xml", "john.xml", "lear.xml", "lll.xml", "m_for_m.xml", "m_wives.xml", "macbeth.xml", "merchant.xml", "much_ado.xml", "othello.xml", "pericles.xml", "r_and_j.xml", "rich_ii.xml", "rich_iii.xml", "t_night.xml", "taming.xml", "tempest.xml", "timon.xml", "titus.xml", "troilus.xml", "two_gent.xml", "win_tale.xml", "config.rtf", "RTF-Spec-1.7.rtf", "sample.rtf", "testrtf.rtf");

    public IsisClobs(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public Clob any() {
        List<String> fileNames = IsisClobs.fileNames;
        return this.asClob(fileNames);
    }

    public Clob anyXml() {
        return this.asClob(IsisClobs.fileNamesEndingWith(".xml"));
    }

    public Clob anyRtf() {
        return this.asClob(IsisClobs.fileNamesEndingWith(".rtf"));
    }

    private Clob asClob(List<String> fileNames) {
        int randomIdx = this.fake.ints().upTo(fileNames.size());
        String randomFileName = fileNames.get(randomIdx);
        return IsisClobs.asClob(randomFileName);
    }

    private static List<String> fileNamesEndingWith(String suffix) {
        return fileNames.stream().filter(input -> input.endsWith(suffix)).collect(Collectors.toList());
    }

    private static Clob asClob(String fileName) {
        Clob clob;
        block8: {
            InputStream is = _Resources.load(IsisBlobs.class, (String)("clobs/" + fileName));
            try {
                clob = new Clob(fileName, IsisClobs.mimeTypeFor(fileName), (CharSequence)_Strings.read((InputStream)is, (Charset)StandardCharsets.US_ASCII));
                if (is == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            is.close();
        }
        return clob;
    }

    private static String mimeTypeFor(String fileName) {
        if (fileName.endsWith("xml")) {
            return "text/xml";
        }
        return "application/rtf";
    }
}

