/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.time.OffsetDateTime;
import java.time.Period;
import java.time.ZoneId;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;

public class JavaTimeDateTimes
extends AbstractRandomValueGenerator {
    public JavaTimeDateTimes(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public OffsetDateTime around(Period period) {
        return this.fake.booleans().coinFlip() ? this.before(period) : this.after(period);
    }

    public OffsetDateTime before(Period period) {
        Period periodWithin = this.fake.javaTimePeriods().within(period);
        return this.now().minus(periodWithin);
    }

    public OffsetDateTime after(Period period) {
        Period periodWithin = this.fake.javaTimePeriods().within(period);
        return this.now().plus(periodWithin);
    }

    public OffsetDateTime any() {
        Period upTo5Years = this.fake.javaTimePeriods().yearsUpTo(5);
        return this.around(upTo5Years);
    }

    private OffsetDateTime now() {
        return this.fake.clockService.getClock().nowAsOffsetDateTime(ZoneId.systemDefault());
    }
}

