/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.time.LocalDate;
import java.time.Period;
import java.time.ZoneId;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;

public class JavaTimeLocalDates
extends AbstractRandomValueGenerator {
    public JavaTimeLocalDates(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public LocalDate around(Period period) {
        return this.fake.booleans().coinFlip() ? this.before(period) : this.after(period);
    }

    public LocalDate before(Period period) {
        Period periodWithin = this.fake.javaTimePeriods().within(period);
        return this.now().minus(periodWithin);
    }

    public LocalDate after(Period period) {
        Period periodWithin = this.fake.javaTimePeriods().within(period);
        return this.now().plus(periodWithin);
    }

    public LocalDate any() {
        Period periodUpTo5Years = this.fake.javaTimePeriods().yearsUpTo(5);
        return this.around(periodUpTo5Years);
    }

    private LocalDate now() {
        return this.fake.clockService.getClock().nowAsLocalDate(ZoneId.systemDefault());
    }
}

