/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.time.Period;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;

public class JavaTimePeriods
extends AbstractRandomValueGenerator {
    public JavaTimePeriods(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public Period daysBetween(int minDays, int maxDays) {
        return Period.ofDays(this.fake.ints().between(minDays, maxDays));
    }

    public Period daysUpTo(int maxDays) {
        return this.daysBetween(0, maxDays);
    }

    public Period monthsBetween(int minMonths, int maxMonths) {
        return Period.ofMonths(this.fake.ints().between(minMonths, maxMonths));
    }

    public Period monthsUpTo(int months) {
        return this.monthsBetween(0, months);
    }

    public Period yearsBetween(int minYears, int maxYears) {
        return Period.ofYears(this.fake.ints().between(minYears, maxYears));
    }

    public Period yearsUpTo(int years) {
        return this.yearsBetween(0, years);
    }

    public Period within(Period period) {
        int newDays = this.fake.ints().between(0, period.getDays());
        int newMonths = this.fake.ints().between(0, period.getMonths());
        int newYears = this.fake.ints().between(0, period.getYears());
        return Period.of(newYears, newMonths, newDays);
    }
}

