/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import java.time.ZoneId;
import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;
import org.joda.time.DateTime;
import org.joda.time.Period;
import org.joda.time.ReadablePeriod;

public class JodaDateTimes
extends AbstractRandomValueGenerator {
    public JodaDateTimes(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public DateTime around(Period period) {
        return this.fake.booleans().coinFlip() ? this.before(period) : this.after(period);
    }

    public DateTime before(Period period) {
        Period periodWithin = this.fake.jodaPeriods().within(period);
        return this.now().minus((ReadablePeriod)periodWithin);
    }

    public DateTime after(Period period) {
        Period periodWithin = this.fake.jodaPeriods().within(period);
        return this.now().plus((ReadablePeriod)periodWithin);
    }

    public DateTime any() {
        Period periodUpTo5Years = this.fake.jodaPeriods().yearsUpTo(5);
        return this.around(periodUpTo5Years);
    }

    private DateTime now() {
        return this.fake.clockService.getClock().nowAsJodaDateTime(ZoneId.systemDefault());
    }
}

