/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fakedata.applib.services;

import org.apache.isis.testing.fakedata.applib.services.AbstractRandomValueGenerator;
import org.apache.isis.testing.fakedata.applib.services.FakeDataService;
import org.joda.time.Period;

public class JodaPeriods
extends AbstractRandomValueGenerator {
    public JodaPeriods(FakeDataService fakeDataService) {
        super(fakeDataService);
    }

    public Period daysBetween(int minDays, int maxDays) {
        return Period.days((int)this.fake.ints().between(minDays, maxDays));
    }

    public Period daysUpTo(int maxDays) {
        return this.daysBetween(0, maxDays);
    }

    public Period monthsBetween(int minMonths, int maxMonths) {
        return Period.months((int)this.fake.ints().between(minMonths, maxMonths));
    }

    public Period monthsUpTo(int months) {
        return this.monthsBetween(0, months);
    }

    public Period yearsBetween(int minYears, int maxYears) {
        return Period.years((int)this.fake.ints().between(minYears, maxYears));
    }

    public Period yearsUpTo(int years) {
        return this.yearsBetween(0, years);
    }

    public Period within(Period period) {
        int newDays = this.fake.ints().between(0, period.getDays());
        int newMonths = this.fake.ints().between(0, period.getMonths());
        int newYears = this.fake.ints().between(0, period.getYears());
        return Period.years((int)newYears).withMonths(newMonths).withDays(newDays);
    }
}

