/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import javax.inject.Inject;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import javax.xml.bind.annotation.XmlType;
import org.apache.isis.applib.annotation.DomainObject;
import org.apache.isis.applib.annotation.DomainObjectLayout;
import org.apache.isis.applib.annotation.Nature;
import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.annotation.Property;
import org.apache.isis.applib.annotation.PropertyLayout;
import org.apache.isis.applib.annotation.Title;
import org.apache.isis.applib.services.bookmark.Bookmark;
import org.apache.isis.applib.services.bookmark.BookmarkService;

@DomainObject(nature=Nature.VIEW_MODEL, logicalTypeName="isis.testing.fixtures.FixtureResult")
@DomainObjectLayout(paged=500)
@XmlRootElement(name="fixtureResult")
@XmlType(propOrder={"fixtureScriptClassName", "fixtureScriptQualifiedName", "key", "objectBookmark"})
@XmlAccessorType(value=XmlAccessType.FIELD)
public class FixtureResult {
    public static final String LOGICAL_TYPE_NAME = "isis.testing.fixtures.FixtureResult";
    @PropertyLayout(named="Fixture script")
    @Property(optionality=Optionality.OPTIONAL)
    private String fixtureScriptClassName;
    private String fixtureScriptQualifiedName;
    @Title(sequence="1", append=": ")
    private String key;
    private String objectBookmark;
    @XmlTransient
    @Inject
    BookmarkService bookmarkService;

    @PropertyLayout(named="Result")
    @Title(sequence="2")
    public Object getObject() {
        return this.bookmarkService.lookup((Bookmark)Bookmark.parse((String)this.objectBookmark).orElse(null)).orElse(null);
    }

    public void setObject(Object object) {
        this.objectBookmark = this.bookmarkService.bookmarkForElseFail(object).toString();
    }

    @PropertyLayout(named="Result class", sequence="3")
    public String getClassName() {
        return this.getObjectBookmark() != null ? this.getObject().getClass().getName() : null;
    }

    public String getFixtureScriptClassName() {
        return this.fixtureScriptClassName;
    }

    public void setFixtureScriptClassName(String fixtureScriptClassName) {
        this.fixtureScriptClassName = fixtureScriptClassName;
    }

    @Programmatic
    public String getFixtureScriptQualifiedName() {
        return this.fixtureScriptQualifiedName;
    }

    public void setFixtureScriptQualifiedName(String fixtureScriptQualifiedName) {
        this.fixtureScriptQualifiedName = fixtureScriptQualifiedName;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    @Programmatic
    public String getObjectBookmark() {
        return this.objectBookmark;
    }

    public void setObjectBookmark(String objectBookmark) {
        this.objectBookmark = objectBookmark;
    }
}

