/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.wrapper.control.SyncControl;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.commons.internal.base._Casts;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.commons.internal.collections._Lists;
import org.apache.isis.commons.internal.collections._Maps;
import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.apache.isis.testing.fixtures.applib.fixturescripts.ExecutionParameters;
import org.apache.isis.testing.fixtures.applib.fixturescripts.ExecutionParametersDefault;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureResult;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureResultList;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.isis.testing.fixtures.applib.personas.BuilderScriptAbstract;
import org.apache.isis.testing.fixtures.applib.personas.PersonaWithBuilderScript;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public abstract class FixtureScript {
    private static final Logger log = LogManager.getLogger(FixtureScript.class);
    public static final FixtureScript NOOP = new FixtureScript(){

        @Override
        protected void execute(ExecutionContext executionContext) {
        }
    };
    protected static final String PATH_SEPARATOR = "/";
    private String friendlyName;
    private String localName;
    private String parentPath;
    private ExecutionContext executionContext;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected ServiceRegistry serviceRegistry;
    @Inject
    @Programmatic
    protected ServiceInjector serviceInjector;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected UserService userService;
    @Inject
    protected WrapperFactory wrapperFactory;
    @Inject
    protected TransactionService transactionService;
    @Inject
    protected PlatformTransactionManager txMan;

    public FixtureScript() {
        this(null, null);
    }

    public FixtureScript(String friendlyName, String localName) {
        this.localName = this.localNameElseDerived(localName);
        this.friendlyName = this.friendlyNameElseDerived(friendlyName);
        this.parentPath = "";
    }

    protected String localNameElseDerived(String str) {
        return str != null ? str : _Strings.asLowerDashed.apply(this.friendlyNameElseDerived(str));
    }

    protected String friendlyNameElseDerived(String str) {
        return str != null ? str : _Strings.asNaturalName2.apply(this.getClass().getSimpleName());
    }

    public String getQualifiedName() {
        return this.getParentPath() + this.getLocalName();
    }

    protected <T> T defaultParam(String parameterName, ExecutionContext ec, T defaultValue) {
        T value = this.valueFor(parameterName, ec, defaultValue);
        this.setParam(parameterName, value);
        return value;
    }

    private <T> T valueFor(String parameterName, ExecutionContext ec, T defaultValue) {
        Class cls = (Class)_Casts.uncheckedCast(defaultValue.getClass());
        T value = this.readParam(parameterName, ec, cls);
        if (value != null) {
            return value;
        }
        return defaultValue;
    }

    protected <T> Optional<T> optionalParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        T value = this.readParam(parameterName, ec, cls);
        return Optional.ofNullable(value);
    }

    protected <T> T checkParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        return this.optionalParam(parameterName, ec, cls).orElseThrow(() -> new IllegalArgumentException(String.format("No value for '%s'", parameterName)));
    }

    private <T> T readParam(String parameterName, ExecutionContext ec, Class<T> cls) {
        Method method;
        Object value = ec.getParameterAsT(parameterName, cls);
        if (value != null) {
            return value;
        }
        try {
            method = this.getClass().getMethod("get" + this.uppercase(parameterName), new Class[0]);
            value = _Casts.uncheckedCast((Object)method.invoke((Object)this, new Object[0]));
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        if (value != null) {
            return value;
        }
        if (cls == Boolean.class || cls == Boolean.TYPE) {
            try {
                method = this.getClass().getMethod("is" + this.uppercase(parameterName), new Class[0]);
                value = _Casts.uncheckedCast((Object)method.invoke((Object)this, new Object[0]));
            }
            catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
                // empty catch block
            }
            if (value != null) {
                return value;
            }
        }
        return null;
    }

    private <T> void setParam(String parameterName, T value) {
        Method[] methods;
        String mutator = "set" + this.uppercase(parameterName);
        for (Method method : methods = this.getClass().getMethods()) {
            if (!method.getName().equals(mutator) || method.getParameterTypes().length != 1) continue;
            try {
                method.invoke((Object)this, value);
            }
            catch (IllegalAccessException | InvocationTargetException reflectiveOperationException) {}
            break;
        }
    }

    private String uppercase(String parameterName) {
        return parameterName.substring(0, 1).toUpperCase() + parameterName.substring(1);
    }

    protected final List<FixtureResult> run(String parameters, FixtureScripts fixtureScripts) {
        try {
            this.executionContext = fixtureScripts.newExecutionContext(parameters);
            this.executionContext.executeChildIfNotAlready(this);
            return this.executionContext.getResults();
        }
        catch (Exception ex) {
            log.error(this.getQualifiedName(), (Throwable)ex);
            throw ex;
        }
    }

    @Programmatic
    public String validateRun(String parameters) {
        return null;
    }

    @Programmatic
    protected abstract void execute(ExecutionContext var1);

    @SafeVarargs
    protected static <T> T coalesce(T ... ts) {
        for (T t : ts) {
            if (t == null) continue;
            return t;
        }
        return null;
    }

    protected <T> T wrap(T domainObject) {
        return (T)this.wrapperFactory.wrap(domainObject);
    }

    protected <T> T w(T domainObject) {
        return this.wrap(domainObject);
    }

    protected <T> T wrap(T domainObject, SyncControl syncControl) {
        return (T)this.wrapperFactory.wrap(domainObject, syncControl);
    }

    protected <T> T unwrap(T possibleWrappedDomainObject) {
        return (T)this.wrapperFactory.unwrap(possibleWrappedDomainObject);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T m(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T wrapMixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.wrapperFactory.wrapMixin(mixinClass, mixedIn);
    }

    protected <T> T wm(Class<T> mixinClass, Object mixedIn) {
        return this.wrapMixin(mixinClass, mixedIn);
    }

    protected TransactionTemplate transactionTemplate() {
        return new TransactionTemplate(this.txMan);
    }

    @Programmatic
    String pathWith(String subkey) {
        return (String)(this.getQualifiedName() != null ? this.getQualifiedName() + PATH_SEPARATOR : "") + subkey;
    }

    public String getFriendlyName() {
        return this.friendlyName;
    }

    public void setFriendlyName(String friendlyName) {
        this.friendlyName = friendlyName;
    }

    @Programmatic
    public String getLocalName() {
        return this.localName;
    }

    public void setLocalName(String localName) {
        this.localName = localName;
    }

    @Programmatic
    public String getParentPath() {
        return this.parentPath;
    }

    @Programmatic
    public void setParentPath(String parentPath) {
        this.parentPath = parentPath;
    }

    public ServiceInjector getServiceInjector() {
        return this.serviceInjector;
    }

    public static class ExecutionContext
    implements ExecutionParameters {
        public static final ExecutionContext NOOP = new ExecutionContext((String)null, null){

            @Override
            public <T> T addResult(FixtureScript script, T object) {
                return object;
            }

            @Override
            public <T> T addResult(FixtureScript script, String key, T object) {
                return object;
            }

            @Override
            public List<FixtureResult> getResults() {
                return Collections.emptyList();
            }
        };
        private final ExecutionParameters executionParameters;
        private final FixtureScripts fixtureScripts;
        private final FixtureResultList fixtureResultList;
        private final List<FixtureScript> previouslyExecuted = _Lists.newArrayList();
        private final Map<Class<? extends FixtureScript>, FixtureScript> fixtureScriptByClass = _Maps.newLinkedHashMap();
        private final Map<FixtureScript, FixtureScript> fixtureScriptByValue = _Maps.newLinkedHashMap();
        private Map<Class<?>, Object> userData = _Maps.newHashMap();

        public ExecutionContext(String parameters, FixtureScripts fixtureScripts) {
            this(new ExecutionParametersDefault(parameters), fixtureScripts);
        }

        @Programmatic
        public static ExecutionContext create(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            return new ExecutionContext(executionParameters, fixtureScripts);
        }

        private ExecutionContext(ExecutionParameters executionParameters, FixtureScripts fixtureScripts) {
            this.fixtureScripts = fixtureScripts;
            this.executionParameters = executionParameters;
            this.fixtureResultList = new FixtureResultList(fixtureScripts, this);
        }

        @Override
        @Programmatic
        public String getParameters() {
            return this.executionParameters.getParameters();
        }

        @Override
        @Programmatic
        public Map<String, String> getParameterMap() {
            return this.executionParameters.getParameterMap();
        }

        @Override
        @Programmatic
        public String getParameter(String parameterName) {
            return this.executionParameters.getParameter(parameterName);
        }

        @Override
        @Programmatic
        public <T> T getParameterAsT(String parameterName, Class<T> cls) {
            return this.executionParameters.getParameterAsT(parameterName, cls);
        }

        @Override
        @Programmatic
        public Boolean getParameterAsBoolean(String parameterName) {
            return this.executionParameters.getParameterAsBoolean(parameterName);
        }

        @Override
        @Programmatic
        public Byte getParameterAsByte(String parameterName) {
            return this.executionParameters.getParameterAsByte(parameterName);
        }

        @Override
        @Programmatic
        public Short getParameterAsShort(String parameterName) {
            return this.executionParameters.getParameterAsShort(parameterName);
        }

        @Override
        @Programmatic
        public Integer getParameterAsInteger(String parameterName) {
            return this.executionParameters.getParameterAsInteger(parameterName);
        }

        @Override
        @Programmatic
        public Long getParameterAsLong(String parameterName) {
            return this.executionParameters.getParameterAsLong(parameterName);
        }

        @Override
        @Programmatic
        public Float getParameterAsFloat(String parameterName) {
            return this.executionParameters.getParameterAsFloat(parameterName);
        }

        @Override
        @Programmatic
        public Double getParameterAsDouble(String parameterName) {
            return this.executionParameters.getParameterAsDouble(parameterName);
        }

        @Override
        @Programmatic
        public Character getParameterAsCharacter(String parameterName) {
            return this.executionParameters.getParameterAsCharacter(parameterName);
        }

        @Override
        @Programmatic
        public BigInteger getParameterAsBigInteger(String parameterName) {
            return this.executionParameters.getParameterAsBigInteger(parameterName);
        }

        @Override
        @Programmatic
        public BigDecimal getParameterAsBigDecimal(String parameterName) {
            return this.executionParameters.getParameterAsBigDecimal(parameterName);
        }

        @Override
        @Programmatic
        public LocalDate getParameterAsLocalDate(String parameterName) {
            return this.executionParameters.getParameterAsLocalDate(parameterName);
        }

        @Override
        @Programmatic
        public LocalDateTime getParameterAsLocalDateTime(String parameterName) {
            return this.executionParameters.getParameterAsLocalDateTime(parameterName);
        }

        @Override
        @Programmatic
        public <T extends Enum<T>> T getParameterAsEnum(String parameterName, Class<T> enumClass) {
            return this.executionParameters.getParameterAsEnum(parameterName, enumClass);
        }

        @Override
        @Programmatic
        public void setParameterIfNotPresent(String parameterName, String parameterValue) {
            this.executionParameters.setParameterIfNotPresent(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Boolean parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Byte parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Short parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Integer parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Long parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Float parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Double parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Character parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, BigInteger parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, java.util.Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Date parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, LocalDate parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, LocalDateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, DateTime parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, BigDecimal parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, Enum<?> parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Override
        @Programmatic
        public void setParameter(String parameterName, String parameterValue) {
            this.executionParameters.setParameter(parameterName, parameterValue);
        }

        @Programmatic
        public List<FixtureResult> getResults() {
            return this.fixtureResultList.getResults();
        }

        @Programmatic
        public <T> T addResult(FixtureScript script, T object) {
            this.fixtureResultList.add(script, object);
            return object;
        }

        @Programmatic
        public <T> T addResult(FixtureScript script, String key, T object) {
            this.fixtureResultList.add(script, key, object);
            return object;
        }

        @Programmatic
        public <T> T lookup(String key, Class<T> cls) {
            return this.fixtureResultList.lookup(key, cls);
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, PersonaWithBuilderScript<?> personaWithBuilderScript) {
            this.executeChildren(callingFixtureScript, personaWithBuilderScript);
        }

        @Programmatic
        public <T, F extends BuilderScriptAbstract<T>> T executeChildT(FixtureScript callingFixtureScript, PersonaWithBuilderScript<F> personaWithBuilderScript) {
            F childFixtureScript = personaWithBuilderScript.builder();
            BuilderScriptAbstract f = (BuilderScriptAbstract)this.executeChildT(callingFixtureScript, (T)childFixtureScript);
            return f.getObject();
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, FixtureScript childFixtureScript) {
            this.executeChildT(callingFixtureScript, childFixtureScript);
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, PersonaWithBuilderScript<?> ... personaWithBuilderScripts) {
            for (PersonaWithBuilderScript<?> builder : personaWithBuilderScripts) {
                Object childFixtureScript = builder.builder();
                this.executeChild(callingFixtureScript, (FixtureScript)childFixtureScript);
            }
        }

        @Programmatic
        public <T extends Enum<?>> void executeChildren(FixtureScript callingFixtureScript, Class<T> personaClass) {
            this.executeChildren(callingFixtureScript, (PersonaWithBuilderScript[])personaClass.getEnumConstants());
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, FixtureScript ... fixtureScripts) {
            this.executeChildren(callingFixtureScript, Arrays.asList(fixtureScripts));
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, List<FixtureScript> fixtureScripts) {
            for (FixtureScript fixtureScript : fixtureScripts) {
                this.executeChild(callingFixtureScript, fixtureScript);
            }
        }

        @Programmatic
        public void executeChildren(FixtureScript callingFixtureScript, Stream<FixtureScript> fixtureScripts) {
            fixtureScripts.forEach(fixtureScript -> this.executeChild(callingFixtureScript, (FixtureScript)fixtureScript));
        }

        @Programmatic
        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, T childFixtureScript) {
            return this.executeChildT(callingFixtureScript, null, childFixtureScript);
        }

        @Programmatic
        public void executeChild(FixtureScript callingFixtureScript, String localNameOverride, FixtureScript childFixtureScript) {
            if (childFixtureScript == null) {
                return;
            }
            this.executeChildT(callingFixtureScript, localNameOverride, childFixtureScript);
        }

        @Programmatic
        public <T extends FixtureScript> T executeChildT(FixtureScript callingFixtureScript, String localNameOverride, T childFixtureScript) {
            childFixtureScript.setParentPath(callingFixtureScript.pathWith(""));
            if (localNameOverride != null) {
                childFixtureScript.setLocalName(localNameOverride);
            }
            callingFixtureScript.serviceInjector.injectServicesInto(childFixtureScript);
            try {
                T childOrPreviouslyExecuted = this.executeChildIfNotAlready(childFixtureScript);
                return childOrPreviouslyExecuted;
            }
            catch (Exception ex) {
                log.error("{}: {}", (Object)childFixtureScript.getQualifiedName(), (Object)ex.getMessage());
                throw ex;
            }
        }

        private <T extends FixtureScript> T executeChildIfNotAlready(T childFixtureScript) {
            FixtureScripts.MultipleExecutionStrategy executionStrategy = this.determineExecutionStrategy(childFixtureScript);
            switch (executionStrategy) {
                case EXECUTE_ONCE_BY_CLASS: {
                    FixtureScript previouslyExecutedScript = this.fixtureScriptByClass.get(childFixtureScript.getClass());
                    if (previouslyExecutedScript == null) {
                        childFixtureScript.execute(this);
                        this.previouslyExecuted.add(childFixtureScript);
                        this.fixtureScriptByClass.put(childFixtureScript.getClass(), childFixtureScript);
                        return childFixtureScript;
                    }
                    return (T)((FixtureScript)_Casts.uncheckedCast((Object)previouslyExecutedScript));
                }
                case EXECUTE_ONCE_BY_VALUE: {
                    return this.executeChildIfNotAlreadyWithValueSemantics(childFixtureScript);
                }
                case EXECUTE: {
                    childFixtureScript.execute(this);
                    this.previouslyExecuted.add(childFixtureScript);
                    return childFixtureScript;
                }
            }
            throw _Exceptions.illegalArgument((String)"Execution strategy: '%s' not recognized", (Object[])new Object[]{executionStrategy});
        }

        private <T extends FixtureScript> FixtureScripts.MultipleExecutionStrategy determineExecutionStrategy(T childFixtureScript) {
            FixtureScripts.MultipleExecutionStrategy executionStrategy;
            if (childFixtureScript instanceof FixtureScriptWithExecutionStrategy) {
                FixtureScriptWithExecutionStrategy fixtureScriptWithExecutionStrategy = (FixtureScriptWithExecutionStrategy)((Object)childFixtureScript);
                executionStrategy = fixtureScriptWithExecutionStrategy.getMultipleExecutionStrategy();
            } else {
                executionStrategy = this.fixtureScripts.getMultipleExecutionStrategy();
            }
            return executionStrategy;
        }

        private <T extends FixtureScript> T executeChildIfNotAlreadyWithValueSemantics(T childFixtureScript) {
            FixtureScript previouslyExecutedScript = this.fixtureScriptByValue.get(childFixtureScript);
            if (previouslyExecutedScript == null) {
                childFixtureScript.execute(this);
                this.previouslyExecuted.add(childFixtureScript);
                this.fixtureScriptByValue.put(childFixtureScript, childFixtureScript);
                return childFixtureScript;
            }
            return (T)((FixtureScript)_Casts.uncheckedCast((Object)previouslyExecutedScript));
        }

        @Programmatic
        public List<FixtureScript> getPreviouslyExecuted() {
            return Collections.unmodifiableList(this.previouslyExecuted);
        }

        static int roundup(int n, int roundTo) {
            return (n / roundTo + 1) * roundTo;
        }

        @Programmatic
        public <T> T clearUserData(Class<T> cls) {
            return (T)_Casts.uncheckedCast((Object)this.userData.remove(cls));
        }

        public Map<Class<?>, Object> getUserData() {
            return this.userData;
        }

        public void setUserData(Map<Class<?>, Object> userData) {
            this.userData = userData;
        }

        static enum As {
            EXEC,
            SKIP;

        }
    }
}

