/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.fixturescripts;

import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecification;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScriptsSpecificationProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfigureOrder(value=0x5FFFFFFF)
@Configuration
public class FixtureScriptsSpecificationProviderAutoConfiguration {
    @Bean(value={"isis.testing.fixtures.FixtureScriptsSpecificationProviderDefault"})
    @ConditionalOnMissingBean(value={FixtureScriptsSpecificationProvider.class})
    @Qualifier(value="Default")
    FixtureScriptsSpecificationProvider fixtureScriptsSpecificationProvider(IsisConfiguration isisConfiguration) {
        IsisConfiguration.Testing.Fixtures.FixtureScriptsSpecification fixturesConfig = isisConfiguration.getTesting().getFixtures().getFixtureScriptsSpecification();
        FixtureScriptsSpecification.Builder builder = FixtureScriptsSpecificationProviderAutoConfiguration.builderFrom(fixturesConfig);
        builder.with(FixtureScripts.NonPersistedObjectsStrategy.valueOf(fixturesConfig.getNonPersistedObjectsStrategy().name()));
        builder.with(FixtureScripts.MultipleExecutionStrategy.valueOf(fixturesConfig.getMultipleExecutionStrategy().name()));
        builder.withRecreate(fixturesConfig.getRecreate());
        builder.withRunScriptDefault(fixturesConfig.getRunScriptDefault());
        return builder::build;
    }

    private static FixtureScriptsSpecification.Builder builderFrom(IsisConfiguration.Testing.Fixtures.FixtureScriptsSpecification fixturesConfig) {
        Class contextClass = fixturesConfig.getContextClass();
        if (contextClass != null) {
            return FixtureScriptsSpecification.builder(contextClass);
        }
        String packagePrefix = fixturesConfig.getPackagePrefix();
        return FixtureScriptsSpecification.builder(packagePrefix);
    }
}

