/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.modules;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.subdomains.spring.applib.service.ContextBeans;
import org.apache.isis.subdomains.spring.applib.service.SpringBeansService;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.isis.testing.fixtures.applib.modules.ModuleWithFixtures;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Import;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.context.event.EventListener;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.testing.fixtures.ModuleWithFixturesService")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class ModuleWithFixturesService {
    private static final Logger log = LogManager.getLogger(ModuleWithFixturesService.class);
    private final SpringBeansService springBeansService;

    @Inject
    public ModuleWithFixturesService(SpringBeansService springBeansService) {
        this.springBeansService = springBeansService;
    }

    public FixtureScript getRefDataSetupFixture() {
        return new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                List<ModuleWithFixturesDescriptor> descriptors = ModuleWithFixturesService.this.modules();
                executionContext.executeChildren((FixtureScript)this, descriptors.stream().map(ModuleWithFixturesDescriptor::getModule).map(ModuleWithFixtures::getRefDataSetupFixture));
            }
        };
    }

    public FixtureScript getTeardownFixture() {
        return new FixtureScript(){

            @Override
            protected void execute(FixtureScript.ExecutionContext executionContext) {
                List<ModuleWithFixturesDescriptor> descriptors = ModuleWithFixturesService.this.modules();
                Collections.reverse(descriptors);
                executionContext.executeChildren((FixtureScript)this, descriptors.stream().map(ModuleWithFixturesDescriptor::getModule).map(ModuleWithFixtures::getTeardownFixture));
            }
        };
    }

    public List<ModuleWithFixturesDescriptor> modules() {
        Map beans = this.springBeansService.beans();
        List<ModuleWithFixturesDescriptor> modules = ModuleWithFixturesService.modulesWithin(beans);
        return ModuleWithFixturesService.sequenced(modules);
    }

    static List<ModuleWithFixturesDescriptor> modulesWithin(Map<String, ContextBeans> beans) {
        ArrayList<ModuleWithFixturesDescriptor> descriptors = new ArrayList<ModuleWithFixturesDescriptor>();
        for (Map.Entry<String, ContextBeans> contextEntry : beans.entrySet()) {
            String contextId = contextEntry.getKey();
            ContextBeans contextBeans = contextEntry.getValue();
            ConfigurableApplicationContext context = contextBeans.getContext();
            Map modulesByBeanName = context.getBeansOfType(ModuleWithFixtures.class);
            Map configurationBeansByBeanName = context.getBeansWithAnnotation(Configuration.class);
            Map beansAnnotatedWithImportByBeanName = context.getBeansWithAnnotation(Import.class);
            for (Map.Entry beanEntry : contextBeans.getBeans().entrySet()) {
                Import importAnnot;
                String beanName = (String)beanEntry.getKey();
                ModuleWithFixtures module = (ModuleWithFixtures)modulesByBeanName.get(beanName);
                if (module == null) continue;
                Object annotatedWithConfiguration = configurationBeansByBeanName.get(beanName);
                Object annotatedWithImport = beansAnnotatedWithImportByBeanName.get(beanName);
                LinkedHashMap<String, ModuleWithFixtures> importedModulesByBeanName = new LinkedHashMap<String, ModuleWithFixtures>();
                if (annotatedWithConfiguration != null && annotatedWithImport != null && (importAnnot = (Import)_Reflect.getAnnotation(annotatedWithImport.getClass(), Import.class)) != null) {
                    Class[] importedClasses = importAnnot.value();
                    Arrays.stream(importedClasses).forEach(importedClass -> {
                        Map importedBeansOfType = context.getBeansOfType(importedClass);
                        importedBeansOfType.forEach((name, entryValue) -> {
                            List<Object> beanCollection = entryValue instanceof Collection ? (List<Object>)entryValue : Collections.singletonList(entryValue);
                            beanCollection.stream().filter(ModuleWithFixtures.class::isInstance).map(ModuleWithFixtures.class::cast).forEach(mod -> importedModulesByBeanName.put((String)name, (ModuleWithFixtures)mod));
                        });
                    });
                }
                ModuleWithFixturesDescriptor descriptor = new ModuleWithFixturesDescriptor(contextId, beanName, module, importedModulesByBeanName);
                descriptors.add(descriptor);
            }
        }
        return descriptors;
    }

    static List<ModuleWithFixturesDescriptor> sequenced(List<ModuleWithFixturesDescriptor> modules) {
        ArrayList<ModuleWithFixturesDescriptor> remaining = new ArrayList<ModuleWithFixturesDescriptor>(modules);
        ArrayList<ModuleWithFixturesDescriptor> sequenced = new ArrayList<ModuleWithFixturesDescriptor>();
        LinkedHashMap<String, ModuleWithFixturesDescriptor> moduleByName = new LinkedHashMap<String, ModuleWithFixturesDescriptor>();
        modules.forEach(module -> moduleByName.put(module.getBeanName(), (ModuleWithFixturesDescriptor)module));
        while (!remaining.isEmpty()) {
            ModuleWithFixturesDescriptor added = ModuleWithFixturesService.addNextModule(sequenced, remaining, moduleByName);
            if (added == null) {
                throw new IllegalStateException(String.format("Unable to determine next module.\nfound = %s\nremaining = %s", ModuleWithFixturesService.beanNamesOf(sequenced), ModuleWithFixturesService.beanNamesOf(remaining)));
            }
            remaining.remove(added);
        }
        return sequenced;
    }

    static List<String> beanNamesOf(ArrayList<ModuleWithFixturesDescriptor> result) {
        return result.stream().map(ModuleWithFixturesDescriptor::getBeanName).collect(Collectors.toList());
    }

    static ModuleWithFixturesDescriptor addNextModule(List<ModuleWithFixturesDescriptor> result, List<ModuleWithFixturesDescriptor> remaining, LinkedHashMap<String, ModuleWithFixturesDescriptor> moduleByName) {
        for (ModuleWithFixturesDescriptor module : remaining) {
            long numDependenciesNotYetEncountered = module.getDependenciesByName().keySet().stream().map(moduleByName::get).filter(dependency -> !result.contains(dependency)).count();
            if (numDependenciesNotYetEncountered != 0L) continue;
            result.add(module);
            return module;
        }
        return null;
    }

    @EventListener(value={ContextRefreshedEvent.class})
    public void onContextRefreshed(ContextRefreshedEvent event) {
        log.info("onContextRefreshed");
        for (ModuleWithFixturesDescriptor descriptor : this.modules()) {
            log.info((Object)descriptor);
        }
    }

    public static class ModuleWithFixturesDescriptor {
        private final String contextId;
        private final String beanName;
        private final ModuleWithFixtures module;
        private final Map<String, ModuleWithFixtures> dependenciesByName;

        public String toString() {
            return "ModuleWithFixturesDescriptor{contextId='" + this.contextId + "', beanName='" + this.beanName + "', dependenciesByName=" + this.dependenciesByName.keySet() + "}";
        }

        public ModuleWithFixturesDescriptor(String contextId, String beanName, ModuleWithFixtures module, Map<String, ModuleWithFixtures> dependenciesByName) {
            this.contextId = contextId;
            this.beanName = beanName;
            this.module = module;
            this.dependenciesByName = dependenciesByName;
        }

        public String getContextId() {
            return this.contextId;
        }

        public String getBeanName() {
            return this.beanName;
        }

        public ModuleWithFixtures getModule() {
            return this.module;
        }

        public Map<String, ModuleWithFixtures> getDependenciesByName() {
            return this.dependenciesByName;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ModuleWithFixturesDescriptor)) {
                return false;
            }
            ModuleWithFixturesDescriptor other = (ModuleWithFixturesDescriptor)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contextId = this.getContextId();
            String other$contextId = other.getContextId();
            if (this$contextId == null ? other$contextId != null : !this$contextId.equals(other$contextId)) {
                return false;
            }
            String this$beanName = this.getBeanName();
            String other$beanName = other.getBeanName();
            if (this$beanName == null ? other$beanName != null : !this$beanName.equals(other$beanName)) {
                return false;
            }
            ModuleWithFixtures this$module = this.getModule();
            ModuleWithFixtures other$module = other.getModule();
            if (this$module == null ? other$module != null : !this$module.equals(other$module)) {
                return false;
            }
            Map<String, ModuleWithFixtures> this$dependenciesByName = this.getDependenciesByName();
            Map<String, ModuleWithFixtures> other$dependenciesByName = other.getDependenciesByName();
            return !(this$dependenciesByName == null ? other$dependenciesByName != null : !((Object)this$dependenciesByName).equals(other$dependenciesByName));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ModuleWithFixturesDescriptor;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contextId = this.getContextId();
            result = result * 59 + ($contextId == null ? 43 : $contextId.hashCode());
            String $beanName = this.getBeanName();
            result = result * 59 + ($beanName == null ? 43 : $beanName.hashCode());
            ModuleWithFixtures $module = this.getModule();
            result = result * 59 + ($module == null ? 43 : $module.hashCode());
            Map<String, ModuleWithFixtures> $dependenciesByName = this.getDependenciesByName();
            result = result * 59 + ($dependenciesByName == null ? 43 : ((Object)$dependenciesByName).hashCode());
            return result;
        }
    }
}

