/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.personas;

import org.apache.isis.applib.annotation.Programmatic;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScriptWithExecutionStrategy;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.isis.testing.fixtures.applib.personas.PersonaWithBuilderScript;
import org.apache.isis.testing.fixtures.applib.personas.PersonaWithFinder;

public abstract class BuilderScriptAbstract<T>
extends FixtureScript
implements FixtureScriptWithExecutionStrategy {
    private final FixtureScripts.MultipleExecutionStrategy multipleExecutionStrategy;

    protected BuilderScriptAbstract() {
        this(FixtureScripts.MultipleExecutionStrategy.EXECUTE_ONCE_BY_VALUE);
    }

    protected BuilderScriptAbstract(FixtureScripts.MultipleExecutionStrategy executionStrategy) {
        this.multipleExecutionStrategy = executionStrategy;
    }

    public abstract T getObject();

    @Programmatic
    public BuilderScriptAbstract<T> build(FixtureScript parentFixtureScript, FixtureScript.ExecutionContext executionContext) {
        parentFixtureScript.getServiceInjector().injectServicesInto((Object)this);
        return executionContext.executeChildT(parentFixtureScript, this);
    }

    public T objectFor(PersonaWithBuilderScript<BuilderScriptAbstract<T>> persona, FixtureScript.ExecutionContext executionContext) {
        if (persona == null) {
            return null;
        }
        BuilderScriptAbstract<T> fixtureScript = persona.builder();
        return executionContext.executeChildT((FixtureScript)this, fixtureScript).getObject();
    }

    public T findUsing(PersonaWithFinder<T> persona) {
        if (persona == null) {
            return null;
        }
        return persona.findUsing(this.serviceRegistry);
    }

    @Override
    public FixtureScripts.MultipleExecutionStrategy getMultipleExecutionStrategy() {
        return this.multipleExecutionStrategy;
    }
}

