/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.fixtures.applib.services;

import java.lang.reflect.InvocationTargetException;
import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.core.config.IsisConfiguration;
import org.apache.isis.core.metamodel.events.MetamodelEvent;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScript;
import org.apache.isis.testing.fixtures.applib.fixturescripts.FixtureScripts;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.event.EventListener;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.testing.fixtures.InitialFixtureScriptsInstaller")
@Priority(value=0x3FFFFFFF)
@Qualifier(value="Default")
public class InitialFixtureScriptsInstaller {
    private static final Logger log = LogManager.getLogger(InitialFixtureScriptsInstaller.class);
    private final FixtureScripts fixtureScripts;
    private FixtureScript initialFixtureScript;

    @Inject
    public InitialFixtureScriptsInstaller(IsisConfiguration isisConfiguration, FixtureScripts fixtureScripts) {
        this.fixtureScripts = fixtureScripts;
        Class initialScript = isisConfiguration.getTesting().getFixtures().getInitialScript();
        if (initialScript != null && FixtureScript.class.isAssignableFrom(initialScript)) {
            try {
                this.initialFixtureScript = (FixtureScript)initialScript.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                this.initialFixtureScript = null;
            }
        }
    }

    @EventListener(value={MetamodelEvent.class})
    @Order(value=2147483547)
    public void onMetamodelEvent(MetamodelEvent event) {
        log.debug("received metamodel event {}", (Object)event);
        if (event.isPostMetamodel() && this.initialFixtureScript != null) {
            log.info("install initial fixtures from script {}", (Object)this.initialFixtureScript.getFriendlyName());
            this.fixtureScripts.run(this.initialFixtureScript);
        }
    }
}

