/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.integtestsupport.applib;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Provider;
import org.apache.isis.applib.services.factory.FactoryService;
import org.apache.isis.applib.services.iactn.InteractionProvider;
import org.apache.isis.applib.services.inject.ServiceInjector;
import org.apache.isis.applib.services.metamodel.MetaModelService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.repository.RepositoryService;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.applib.services.wrapper.WrapperFactory;
import org.apache.isis.applib.services.xactn.TransactionService;
import org.apache.isis.testing.integtestsupport.applib.ExceptionRecognizerTranslate;
import org.apache.isis.testing.integtestsupport.applib.IsisInteractionHandler;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.stereotype.Service;

@ExtendWith(value={ExceptionRecognizerTranslate.class, IsisInteractionHandler.class})
public abstract class IsisIntegrationTestAbstract {
    @Inject
    protected ServiceRegistry serviceRegistry;
    @Inject
    protected MetaModelService metaModelService;
    @Inject
    protected FactoryService factoryService;
    @Inject
    protected RepositoryService repositoryService;
    @Inject
    protected ServiceInjector serviceInjector;
    @Inject
    protected UserService userService;
    @Inject
    protected WrapperFactory wrapperFactory;
    @Inject
    protected TransactionService transactionService;

    protected <T> T wrap(T obj) {
        return (T)this.wrapperFactory.wrap(obj);
    }

    protected <T> T w(T obj) {
        return this.wrap(obj);
    }

    protected <T> T wrapMixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.wrapperFactory.wrapMixin(mixinClass, mixedIn);
    }

    protected <T> T wm(Class<T> mixinClass, Object mixedIn) {
        return this.wrapMixin(mixinClass, mixedIn);
    }

    protected <T> T mixin(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T m(Class<T> mixinClass, Object mixedIn) {
        return (T)this.factoryService.mixin(mixinClass, mixedIn);
    }

    protected <T> T unwrap(T obj) {
        return (T)this.wrapperFactory.unwrap(obj);
    }

    ServiceRegistry getServiceRegistry() {
        return this.serviceRegistry;
    }

    @Service
    @Priority(value=0x3FFFFFFF)
    public static class InteractionSupport {
        private final Provider<InteractionProvider> interactionProviderProvider;

        @Inject
        public InteractionSupport(Provider<InteractionProvider> interactionProviderProvider) {
            this.interactionProviderProvider = interactionProviderProvider;
        }
    }
}

