/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.integtestsupport.applib;

import java.lang.reflect.AnnotatedElement;
import java.util.Optional;
import org.apache.isis.applib.services.exceprecog.ExceptionRecognizerService;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.iactnlayer.InteractionService;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.commons.internal.reflection._Annotations;
import org.apache.isis.testing.integtestsupport.applib.IsisIntegrationTestAbstract;
import org.apache.isis.testing.integtestsupport.applib.annotation.InteractAs;
import org.apache.isis.testing.integtestsupport.applib.annotation.InteractAsUtils;
import org.junit.jupiter.api.extension.ExtensionContext;

class _Helper {
    _Helper() {
    }

    static Optional<ServiceRegistry> getServiceRegistry(ExtensionContext extensionContext) {
        return extensionContext.getTestInstance().filter(IsisIntegrationTestAbstract.class::isInstance).map(IsisIntegrationTestAbstract.class::cast).map(IsisIntegrationTestAbstract::getServiceRegistry);
    }

    static Optional<InteractionContext> getCustomInteractionContext(ExtensionContext extensionContext) {
        return extensionContext.getTestMethod().flatMap(testMethod -> _Annotations.synthesize((AnnotatedElement)testMethod, InteractAs.class)).map(InteractAsUtils::toInteractionContext);
    }

    static Optional<InteractionService> getInteractionFactory(ExtensionContext extensionContext) {
        return _Helper.getServiceRegistry(extensionContext).flatMap(serviceRegistry -> serviceRegistry.lookupService(InteractionService.class));
    }

    static Optional<ExceptionRecognizerService> getExceptionRecognizerService(ExtensionContext extensionContext) {
        return _Helper.getServiceRegistry(extensionContext).flatMap(serviceRegistry -> serviceRegistry.lookupService(ExceptionRecognizerService.class));
    }
}

