/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.integtestsupport.applib.annotation;

import java.time.OffsetDateTime;
import java.util.Locale;
import org.apache.isis.applib.clock.VirtualClock;
import org.apache.isis.applib.locale.UserLocale;
import org.apache.isis.applib.services.iactnlayer.InteractionContext;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.config.progmodel.ProgrammingModelConstants;
import org.apache.isis.testing.integtestsupport.applib.annotation.InteractAs;

public final class InteractAsUtils {
    public static InteractionContext toInteractionContext(InteractAs testWith) {
        UserMemento user = _Strings.isNotEmpty((CharSequence)testWith.userName()) ? UserMemento.ofName((String)testWith.userName()) : UserMemento.system();
        Locale mainLocale = _Strings.isNotEmpty((CharSequence)testWith.localeName()) ? Locale.forLanguageTag(testWith.localeName()) : Locale.getDefault();
        VirtualClock virtualClock = _Strings.isNotEmpty((CharSequence)testWith.frozenDateTime()) ? VirtualClock.frozenAt((OffsetDateTime)ProgrammingModelConstants.DateTimeFormat.CANONICAL.parseDateTime(testWith.frozenDateTime())) : VirtualClock.system();
        return InteractionContext.ofUserWithSystemDefaults((UserMemento)user).withLocale(UserLocale.valueOf((Locale)mainLocale)).withClock(virtualClock);
    }

    private InteractAsUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

