/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.integtestsupport.applib.swagger;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Collections;
import javax.inject.Inject;
import org.apache.isis.applib.services.registry.ServiceRegistry;
import org.apache.isis.applib.services.swagger.Format;
import org.apache.isis.applib.services.swagger.SwaggerService;
import org.apache.isis.applib.services.swagger.Visibility;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SwaggerExporter {
    private static final Logger log = LogManager.getLogger(SwaggerExporter.class);
    private final SwaggerService swaggerService;

    @Inject
    public SwaggerExporter(ServiceRegistry registry) {
        this((SwaggerService)registry.lookupServiceElseFail(SwaggerService.class));
    }

    public SwaggerExporter(SwaggerService swaggerService) {
        this.swaggerService = swaggerService;
    }

    public void export(Visibility visibility, Format format) throws IOException {
        this.export(visibility, format, this.defaultOutputDir());
    }

    public void export(Visibility visibility, Format format, File outputDir) throws IOException {
        this.export(visibility, format, outputDir, this.defaultFileNamePrefix());
    }

    public void export(Visibility visibility, Format format, File outputDir, String fileNamePrefix) throws IOException {
        File swaggerSpecFile = this.buildSwaggerSpecFile(outputDir, fileNamePrefix, visibility, format);
        this.writeSwaggerSpec(visibility, format, swaggerSpecFile);
        this.swaggerService.generateSwaggerSpec(visibility, format);
    }

    private File buildSwaggerSpecFile(File outputDir, String fileNamePrefix, Visibility visibility, Format format) {
        String swaggerSpecName = fileNamePrefix + "-" + visibility + "." + format.name().toLowerCase();
        return new File(outputDir, swaggerSpecName);
    }

    private void writeSwaggerSpec(Visibility visibility, Format format, File swaggerSpecFile) throws IOException {
        String swaggerSpec = this.swaggerService.generateSwaggerSpec(visibility, format);
        SwaggerExporter.createParentDirs(swaggerSpecFile);
        Files.write(swaggerSpecFile.toPath(), Collections.singletonList(swaggerSpec), new OpenOption[0]);
    }

    private static void createParentDirs(File file) throws IOException {
        File parent = file.getCanonicalFile().getParentFile();
        if (parent != null) {
            parent.mkdirs();
            if (!parent.isDirectory()) {
                throw new IOException("Unable to create parent directories of " + file);
            }
        }
    }

    private File defaultOutputDir() {
        return new File("target/generated-resources/swagger-export");
    }

    private String defaultFileNamePrefix() {
        return "swagger";
    }
}

