/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.dom.value;

import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.Matchers;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public abstract class ValueTypeContractTestAbstract<T> {
    @Before
    public void setUp() throws Exception {
        this.assertSizeAtLeast(this.getObjectsWithSameValue(), 2);
        this.assertSizeAtLeast(this.getObjectsWithDifferentValue(), 1);
    }

    private void assertSizeAtLeast(List<T> objects, int i) {
        MatcherAssert.assertThat(objects, (Matcher)Matchers.is((Matcher)Matchers.notNullValue()));
        MatcherAssert.assertThat((Object)objects.size(), (Matcher)Matchers.is((Matcher)Matchers.greaterThan((Comparable)Integer.valueOf(i - 1))));
    }

    @Test
    public void notEqualToNull() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            MatcherAssert.assertThat((Object)(o1 == null ? 1 : 0), (Matcher)Matchers.is((Object)false));
        }
        for (T o1 : this.getObjectsWithDifferentValue()) {
            MatcherAssert.assertThat((Object)(o1 == null ? 1 : 0), (Matcher)Matchers.is((Object)false));
        }
    }

    @Test
    public void reflexiveAndSymmetric() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithSameValue()) {
                MatcherAssert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)o2.equals(o1), (Matcher)Matchers.is((Object)true));
                MatcherAssert.assertThat((Object)o1.hashCode(), (Matcher)Matchers.is((Matcher)Matchers.equalTo((Object)o2.hashCode())));
            }
        }
    }

    @Test
    public void notEqual() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithDifferentValue()) {
                MatcherAssert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)false));
                MatcherAssert.assertThat((Object)o2.equals(o1), (Matcher)Matchers.is((Object)false));
            }
        }
    }

    @Test
    public void transitiveWhenEqual() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            for (T o2 : this.getObjectsWithSameValue()) {
                for (T o3 : this.getObjectsWithSameValue()) {
                    MatcherAssert.assertThat((Object)o1.equals(o2), (Matcher)Matchers.is((Object)true));
                    MatcherAssert.assertThat((Object)o2.equals(o3), (Matcher)Matchers.is((Object)true));
                    MatcherAssert.assertThat((Object)o1.equals(o3), (Matcher)Matchers.is((Object)true));
                }
            }
        }
    }

    @Test
    public void comparableEquivalence() throws Exception {
        for (T o1 : this.getObjectsWithSameValue()) {
            Comparable c2;
            Assume.assumeThat((Object)(o1 instanceof Comparable), (Matcher)Matchers.is((Object)true));
            Comparable c1 = (Comparable)o1;
            for (T o2 : this.getObjectsWithSameValue()) {
                Assume.assumeThat((Object)(o2 instanceof Comparable), (Matcher)Matchers.is((Object)true));
                c2 = (Comparable)o2;
                MatcherAssert.assertThat((Object)c1.compareTo(c2), (Matcher)Matchers.is((Object)0));
                MatcherAssert.assertThat((Object)c2.compareTo(c1), (Matcher)Matchers.is((Object)0));
            }
            for (T o2 : this.getObjectsWithDifferentValue()) {
                Assume.assumeThat((Object)(o2 instanceof Comparable), (Matcher)Matchers.is((Object)true));
                c2 = (Comparable)o2;
                int x = c1.compareTo(c2);
                int y = c2.compareTo(c1);
                MatcherAssert.assertThat((Object)x, (Matcher)Matchers.is((Matcher)Matchers.not((Object)0)));
                MatcherAssert.assertThat((Object)x, (Matcher)Matchers.is((Object)(-y)));
            }
        }
    }

    protected abstract List<T> getObjectsWithSameValue();

    protected abstract List<T> getObjectsWithDifferentValue();
}

