/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.jmocking;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.apache.isis.commons.internal.reflection._Reflect;
import org.apache.isis.testing.unittestsupport.applib.jmocking.JUnitRuleMockery2;
import org.jmock.Sequence;
import org.jmock.States;
import org.jmock.auto.Auto;
import org.jmock.auto.Mock;

class MyMockomatic {
    private final JUnitRuleMockery2 context;

    public MyMockomatic(JUnitRuleMockery2 context) {
        this.context = context;
    }

    public List<Object> fillIn(Object object, List<Field> knownFields) {
        ArrayList<Object> mocks = new ArrayList<Object>();
        for (Field field : knownFields) {
            this.autoMockIfAnnotated(object, field, mocks);
            this.autoInstantiateIfAnnotated(object, field);
        }
        return mocks;
    }

    private void autoMockIfAnnotated(Object object, Field field, List<Object> mocks) {
        if (!field.isAnnotationPresent(Mock.class)) {
            return;
        }
        Object mock = this.context.mock(field.getType(), field.getName());
        this.setAutoField(field, object, mock, "auto-mock field " + field.getName());
        if (field.isAnnotationPresent(JUnitRuleMockery2.Ignoring.class)) {
            this.context.ignoring(mock);
        }
        if (field.isAnnotationPresent(JUnitRuleMockery2.Allowing.class)) {
            this.context.allowing(mock);
        }
        if (field.isAnnotationPresent(JUnitRuleMockery2.Never.class)) {
            this.context.never(mock);
        }
        if (field.isAnnotationPresent(JUnitRuleMockery2.One.class)) {
            this.context.oneOf(mock);
        }
        if (field.isAnnotationPresent(JUnitRuleMockery2.Checking.class)) {
            this.checking(field, mock);
        }
        mocks.add(mock);
    }

    private <T> void checking(Field field, T mock) {
        JUnitRuleMockery2.Checking checking = field.getAnnotation(JUnitRuleMockery2.Checking.class);
        Class<? extends JUnitRuleMockery2.ExpectationsOn> expectationsOnClass = checking.value();
        this.context.checking(mock, expectationsOnClass);
    }

    private void autoInstantiateIfAnnotated(Object object, Field field) {
        if (!field.isAnnotationPresent(Auto.class)) {
            return;
        }
        Class<?> type = field.getType();
        if (type == States.class) {
            this.autoInstantiateStates(field, object);
        } else if (type == Sequence.class) {
            this.autoInstantiateSequence(field, object);
        } else {
            throw new IllegalStateException("cannot auto-instantiate field of type " + type.getName());
        }
    }

    private void autoInstantiateStates(Field field, Object object) {
        this.setAutoField(field, object, this.context.states(field.getName()), "auto-instantiate States field " + field.getName());
    }

    private void autoInstantiateSequence(Field field, Object object) {
        this.setAutoField(field, object, this.context.sequence(field.getName()), "auto-instantiate Sequence field " + field.getName());
    }

    private void setAutoField(Field field, Object object, Object value, String description) {
        try {
            _Reflect.setFieldOn((Field)field, (Object)object, (Object)value);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException("cannot " + description, e);
        }
    }
}

