/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.matchers;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;

public final class ListMatchers {
    private ListMatchers() {
    }

    public static Matcher<List<?>> containsElementThat(final Matcher<?> elementMatcher) {
        return new TypeSafeMatcher<List<?>>(){

            public boolean matchesSafely(List<?> list) {
                for (Object o : list) {
                    if (!elementMatcher.matches(o)) continue;
                    return true;
                }
                return false;
            }

            public void describeTo(Description description) {
                description.appendText("contains element that ").appendDescriptionOf((SelfDescribing)elementMatcher);
            }
        };
    }

    public static <T> Matcher<List<T>> sameContentsAs(final List<T> expected) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description description) {
                description.appendText("same sequence as " + expected);
            }

            public boolean matchesSafely(List<T> actual) {
                return actual.containsAll(expected) && expected.containsAll(actual);
            }
        };
    }

    public static <T> Matcher<List<T>> listContaining(final T t) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("list containing ").appendValue(t);
            }

            public boolean matchesSafely(List<T> arg0) {
                return arg0.contains(t);
            }
        };
    }

    @SafeVarargs
    public static <T> Matcher<List<T>> listContainingAll(final T ... items) {
        return new TypeSafeMatcher<List<T>>(){

            public void describeTo(Description arg0) {
                arg0.appendText("has items ").appendValue((Object)items);
            }

            public boolean matchesSafely(List<T> arg0) {
                return arg0.containsAll(Arrays.asList(items));
            }
        };
    }

    public static Matcher<List<Object>> containsObjectOfType(final Class<?> cls) {
        return new TypeSafeMatcher<List<Object>>(){

            public void describeTo(Description desc) {
                desc.appendText("contains instance of type " + cls.getName());
            }

            public boolean matchesSafely(List<Object> items) {
                for (Object object : items) {
                    if (!cls.isAssignableFrom(object.getClass())) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

