/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.matchers;

import org.apache.isis.commons.internal.exceptions._Exceptions;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class ThrowableMatchers {
    ThrowableMatchers() {
    }

    public static TypeSafeMatcher<Throwable> causedBy(final Class<? extends Throwable> type) {
        return new TypeSafeMatcher<Throwable>(){

            protected boolean matchesSafely(Throwable throwable) {
                return _Exceptions.getCausalChain((Throwable)throwable).stream().anyMatch(t -> t.getClass().equals(type));
            }

            public void describeTo(Description description) {
                description.appendText("Caused by " + type.getName());
            }
        };
    }

    public Matcher<Throwable> causalChainHasMessageWith(final String messageFragment) {
        return new TypeSafeMatcher<Throwable>(){

            public void describeTo(Description arg0) {
                arg0.appendText("causal chain has message with " + messageFragment);
            }

            protected boolean matchesSafely(Throwable e) {
                for (Throwable ex : _Exceptions.getCausalChain((Throwable)e)) {
                    if (!ex.getMessage().contains(messageFragment)) continue;
                    return true;
                }
                return false;
            }
        };
    }
}

