/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.testing.unittestsupport.applib.soap;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.testing.unittestsupport.applib.soap.SoapEndpointSpec;
import org.apache.isis.testing.unittestsupport.applib.soap.SoapPublishedEndpoints;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class SoapEndpointPublishingRule
implements TestRule {
    public SoapEndpointPublishingRule(Class<?> endpointClass, String endpointAddress) {
        SoapPublishedEndpoints.instance().publishIfRequired(new SoapEndpointSpec(endpointClass, endpointAddress));
    }

    public SoapEndpointPublishingRule(Class<?> ... endpointClasses) {
        SoapPublishedEndpoints.instance().publishIfRequired(_NullSafe.stream((Object[])endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new)));
    }

    public SoapEndpointPublishingRule(List<Class<?>> endpointClasses) {
        SoapPublishedEndpoints.instance().publishIfRequired(_NullSafe.stream(endpointClasses).map(SoapEndpointSpec::asSoapEndpointSpec).collect(Collectors.toCollection(ArrayList::new)));
    }

    public SoapEndpointPublishingRule(SoapEndpointSpec ... soapEndpointSpecs) {
        SoapPublishedEndpoints.instance().publishIfRequired(_NullSafe.stream((Object[])soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new)));
    }

    public SoapEndpointPublishingRule(Iterable<SoapEndpointSpec> soapEndpointSpecs) {
        SoapPublishedEndpoints.instance().publishIfRequired(_NullSafe.stream(soapEndpointSpecs).collect(Collectors.toCollection(ArrayList::new)));
    }

    public Statement apply(Statement base, Description description) {
        return base;
    }

    public String getEndpointAddress(Class<?> endpointClass) {
        return SoapPublishedEndpoints.instance().getEndpointAddress(endpointClass);
    }

    public <T> T getEndpointImplementor(Class<T> endpointClass) {
        return SoapPublishedEndpoints.instance().getEndpointImplementor(endpointClass);
    }
}

