/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model;

import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.apache.isis.viewer.common.model.mixin.HasUiComponent;

public class UiComponentHolder<T>
implements HasUiComponent<T> {
    protected final Supplier<T> componentFactory;
    private final AtomicReference<Object> uiComponent = new AtomicReference();

    public UiComponentHolder(Supplier<T> componentFactory) {
        this.componentFactory = componentFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T getUiComponent() {
        Object value = this.uiComponent.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.uiComponent;
            synchronized (atomicReference) {
                value = this.uiComponent.get();
                if (value == null) {
                    T actualValue = this.componentFactory.get();
                    value = actualValue == null ? this.uiComponent : actualValue;
                    this.uiComponent.set(value);
                }
            }
        }
        return (T)(value == this.uiComponent ? null : value);
    }
}

