/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.action;

import java.util.stream.Stream;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.commons.internal.assertions._Assert;
import org.apache.isis.core.metamodel.consent.Consent;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.interactions.InteractionHead;
import org.apache.isis.core.metamodel.interactions.managed.ActionInteractionHead;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;
import org.apache.isis.viewer.common.model.action.HasActionInteraction;
import org.apache.isis.viewer.common.model.feature.ParameterUiModel;
import org.apache.isis.viewer.common.model.mixin.HasTitle;

public interface ActionFormUiModel
extends HasTitle,
HasActionInteraction {
    public Stream<? extends ParameterUiModel> streamPendingParamUiModels();

    default public Consent getUsabilityConsent() {
        return this.getAction().isUsable(this.getActionOwner(), InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
    }

    default public Consent getVisibilityConsent() {
        return this.getAction().isVisible(this.getActionOwner(), InteractionInitiatedBy.USER, Where.OBJECT_FORMS);
    }

    default public Consent getValidityConsent() {
        Can proposedArguments = (Can)this.streamPendingParamUiModels().map(ParameterUiModel::getValue).collect(Can.toCan());
        _Assert.assertEquals((Object)this.getAction().getParameterCount(), (Object)proposedArguments.size());
        ActionInteractionHead head = this.getAction().interactionHead(this.getActionOwner());
        return this.getAction().isArgumentSetValid((InteractionHead)head, proposedArguments, InteractionInitiatedBy.USER);
    }

    @Override
    default public String getTitle() {
        ManagedObject owner = this.getActionOwner();
        StringBuilder buf = new StringBuilder();
        this.streamPendingParamUiModels().filter(paramModel -> paramModel.getParameterNegotiationModel().getVisibilityConsent(paramModel.getParameterIndex()).isAllowed()).map(ParameterUiModel::getValue).forEach(paramValue -> {
            if (buf.length() > 0) {
                buf.append(",");
            }
            buf.append(ManagedObjects.abbreviatedTitleOf((ManagedObject)paramValue, (int)8, (String)"..."));
        });
        return owner.titleString() + "." + this.getFriendlyName() + (String)(buf.length() > 0 ? "(" + buf.toString() + ")" : "");
    }
}

