/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.action;

import java.util.Optional;
import java.util.function.Predicate;
import org.apache.isis.applib.Identifier;
import org.apache.isis.applib.annotation.ActionLayout;
import org.apache.isis.applib.annotation.BookmarkPolicy;
import org.apache.isis.core.metamodel.facets.SingleValueFacet;
import org.apache.isis.core.metamodel.facets.members.cssclass.CssClassFacet;
import org.apache.isis.core.metamodel.facets.object.bookmarkpolicy.BookmarkPolicyFacet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.viewer.common.model.decorator.disable.DisablingUiModel;
import org.apache.isis.viewer.common.model.decorator.icon.FontAwesomeUiModel;

@FunctionalInterface
public interface HasManagedAction {
    public ManagedAction getManagedAction();

    default public ObjectAction getAction() {
        return this.getManagedAction().getAction();
    }

    default public ManagedObject getActionOwner() {
        return this.getManagedAction().getOwner();
    }

    default public String getFriendlyName() {
        return this.getManagedAction().getFriendlyName();
    }

    default public Optional<String> getDescription() {
        return this.getManagedAction().getDescription();
    }

    default public boolean hasParameters() {
        return this.getAction().getParameterCount() > 0;
    }

    default public boolean isBookmarkable() {
        ObjectAction action = this.getAction();
        return action.getSemantics().isSafeInNature() && action.lookupFacet(BookmarkPolicyFacet.class).map(SingleValueFacet::value).map(bookmarkPolicy -> bookmarkPolicy == BookmarkPolicy.AS_ROOT).orElse(false) != false;
    }

    default public Identifier getFeatureIdentifier() {
        return this.getAction().getFeatureIdentifier();
    }

    default public Optional<FontAwesomeUiModel> getFontAwesomeUiModel() {
        ManagedAction managedAction = this.getManagedAction();
        return FontAwesomeUiModel.of(ObjectAction.Util.cssClassFaFactoryFor((ObjectAction)managedAction.getAction(), (ManagedObject)managedAction.getOwner()));
    }

    default public Optional<String> getAdditionalCssClass() {
        return this.getAction().lookupFacet(CssClassFacet.class).map(cssClassFacet -> cssClassFacet.cssClass(this.getManagedAction().getOwner()));
    }

    default public ActionLayout.Position getPosition() {
        return ObjectAction.Util.actionLayoutPositionOf((ObjectAction)this.getAction());
    }

    public static <T extends HasManagedAction> Predicate<T> isPositionedAt(ActionLayout.Position position) {
        return a -> a.getPosition() == position;
    }

    default public Optional<DisablingUiModel> getDisableUiModel() {
        return DisablingUiModel.of(this.getManagedAction().checkUsability());
    }
}

