/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.binding;

public interface BindingConverter<L, R> {
    public L toLeft(R var1);

    public R toRight(L var1);

    public static <T> BindingConverter<T, T> identity(Class<T> type) {
        return new BindingConverter<T, T>(){

            @Override
            public T toLeft(T right) {
                return right;
            }

            @Override
            public T toRight(T left) {
                return left;
            }
        };
    }

    default public BindingConverter<R, L> reverse() {
        final BindingConverter self = this;
        return new BindingConverter<R, L>(){

            @Override
            public R toLeft(L right) {
                return self.toRight(right);
            }

            @Override
            public L toRight(R left) {
                return self.toLeft(left);
            }
        };
    }
}

