/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.components;

import org.apache.isis.applib.annotation.Optionality;
import org.apache.isis.core.metamodel.commons.StringExtensions;
import org.springframework.lang.Nullable;

public enum ComponentType {
    ABOUT,
    WELCOME,
    SERVICE_ACTIONS,
    ENTITY,
    ENTITY_ICON_AND_TITLE,
    ENTITY_ICON_TITLE_AND_COPYLINK,
    ENTITY_SUMMARY,
    ENTITY_COLLECTION,
    VALUE,
    SCALAR_NAME_AND_VALUE,
    PARAMETERS,
    PROPERTY_EDIT_FORM,
    ACTION_INFO,
    ACTION_PROMPT,
    PROPERTY_EDIT_PROMPT,
    STANDALONE_COLLECTION,
    COLLECTION_CONTENTS,
    COLLECTION_CONTENTS_EXPORT(Optionality.OPTIONAL),
    ENTITY_LINK,
    EMPTY_COLLECTION,
    VOID_RETURN,
    BOOKMARKED_PAGES,
    UNKNOWN,
    HEADER,
    FOOTER;

    private final Optionality optionality;

    private ComponentType() {
        this.optionality = Optionality.MANDATORY;
    }

    public String toString() {
        return this.getId();
    }

    public String getId() {
        return StringExtensions.toCamelCase((String)this.name());
    }

    @Nullable
    public static ComponentType lookup(String id) {
        for (ComponentType componentType : ComponentType.values()) {
            if (!componentType.getId().equals(id)) continue;
            return componentType;
        }
        return null;
    }

    private ComponentType(Optionality optionality) {
        this.optionality = optionality;
    }

    public Optionality getOptionality() {
        return this.optionality;
    }
}

