/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.decorator.confirm;

import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.core.config.messages.MessageRegistry;

public class ConfirmUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    final String title;
    @NonNull
    final Optional<String> message;
    @NonNull
    final String okLabel;
    @NonNull
    final String cancelLabel;
    @NonNull
    final Placement placement;

    public static ConfirmUiModel ofAreYouSure(TranslationService translationService, Placement placement) {
        TranslationContext context = TranslationContext.forClassName(MessageRegistry.class);
        String areYouSure = ConfirmUiModel.translate(translationService, context, "Are you sure?");
        String confirm = ConfirmUiModel.translate(translationService, context, "Confirm");
        String cancel = ConfirmUiModel.translate(translationService, context, "Cancel");
        Optional<String> message = Optional.empty();
        return ConfirmUiModel.of(areYouSure, message, confirm, cancel, placement);
    }

    private static String translate(TranslationService translationService, TranslationContext context, String msg) {
        if (translationService != null) {
            return translationService.translate(context, msg);
        }
        return msg;
    }

    @NonNull
    public String getTitle() {
        return this.title;
    }

    @NonNull
    public Optional<String> getMessage() {
        return this.message;
    }

    @NonNull
    public String getOkLabel() {
        return this.okLabel;
    }

    @NonNull
    public String getCancelLabel() {
        return this.cancelLabel;
    }

    @NonNull
    public Placement getPlacement() {
        return this.placement;
    }

    private ConfirmUiModel(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull Placement placement) {
        if (title == null) {
            throw new NullPointerException("title is marked non-null but is null");
        }
        if (message == null) {
            throw new NullPointerException("message is marked non-null but is null");
        }
        if (okLabel == null) {
            throw new NullPointerException("okLabel is marked non-null but is null");
        }
        if (cancelLabel == null) {
            throw new NullPointerException("cancelLabel is marked non-null but is null");
        }
        if (placement == null) {
            throw new NullPointerException("placement is marked non-null but is null");
        }
        this.title = title;
        this.message = message;
        this.okLabel = okLabel;
        this.cancelLabel = cancelLabel;
        this.placement = placement;
    }

    public static ConfirmUiModel of(@NonNull String title, @NonNull Optional<String> message, @NonNull String okLabel, @NonNull String cancelLabel, @NonNull Placement placement) {
        return new ConfirmUiModel(title, message, okLabel, cancelLabel, placement);
    }

    public static enum Placement {
        TOP,
        BOTTOM,
        RIGHT,
        LEFT;

    }
}

