/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.decorator.disable;

import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.core.metamodel.interactions.managed.InteractionVeto;
import org.apache.isis.core.metamodel.interactions.managed.MemberInteraction;

public class DisablingUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    final String reason;

    public static Optional<DisablingUiModel> of(@NonNull Optional<InteractionVeto> usabilityVeto) {
        if (usabilityVeto == null) {
            throw new NullPointerException("usabilityVeto is marked non-null but is null");
        }
        return usabilityVeto.map(veto -> DisablingUiModel.of(veto.getReason()));
    }

    public static Optional<DisablingUiModel> of(@NonNull MemberInteraction<?, ?> memberInteraction) {
        if (memberInteraction == null) {
            throw new NullPointerException("memberInteraction is marked non-null but is null");
        }
        return DisablingUiModel.of(memberInteraction.getInteractionVeto());
    }

    @NonNull
    public String getReason() {
        return this.reason;
    }

    private DisablingUiModel(@NonNull String reason) {
        if (reason == null) {
            throw new NullPointerException("reason is marked non-null but is null");
        }
        this.reason = reason;
    }

    private static DisablingUiModel of(@NonNull String reason) {
        return new DisablingUiModel(reason);
    }
}

