/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.decorator.icon;

import java.io.Serializable;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lombok.NonNull;
import org.apache.isis.applib.layout.component.CssClassFaPosition;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.facets.members.cssclassfa.CssClassFaFactory;

public class FontAwesomeUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final String cssClassesSpaceSeparated;
    @NonNull
    private final CssClassFaPosition position;

    public static Optional<FontAwesomeUiModel> of(Optional<CssClassFaFactory> cssClassFaFactoryIfAny) {
        return cssClassFaFactoryIfAny.map(cssClassFaFactory -> new FontAwesomeUiModel(cssClassFaFactory.streamCssClasses().collect(Collectors.joining(" ")), Optional.ofNullable(cssClassFaFactory.getPosition()).orElse(CssClassFaPosition.LEFT)));
    }

    public Stream<String> streamCssClasses() {
        return _Strings.splitThenStream((String)this.getCssClassesSpaceSeparated(), (String)" ");
    }

    @NonNull
    public String getCssClassesSpaceSeparated() {
        return this.cssClassesSpaceSeparated;
    }

    @NonNull
    public CssClassFaPosition getPosition() {
        return this.position;
    }

    private FontAwesomeUiModel(@NonNull String cssClassesSpaceSeparated, @NonNull CssClassFaPosition position) {
        if (cssClassesSpaceSeparated == null) {
            throw new NullPointerException("cssClassesSpaceSeparated is marked non-null but is null");
        }
        if (position == null) {
            throw new NullPointerException("position is marked non-null but is null");
        }
        this.cssClassesSpaceSeparated = cssClassesSpaceSeparated;
        this.position = position;
    }
}

