/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.decorator.prototyping;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.isis.core.metamodel.facetapi.Facet;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.interactions.managed.ManagedMember;
import org.apache.isis.core.metamodel.spec.ObjectSpecification;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;

public class PrototypingUiModel {
    private final Class<?> featureType;
    private final String featureFriendlyName;
    private final String featureFriendlyIdentifier;
    private final Supplier<Stream<Facet>> facetStreamProvider;

    public static PrototypingUiModel of(ManagedAction managedAction) {
        Class featureType = managedAction.getAction().getReturnType().getCorrespondingClass();
        String featureShortLabel = managedAction.getFriendlyName();
        String featureFullLabel = String.format("%s: %s", managedAction.getMemberType(), managedAction.getId());
        return new PrototypingUiModel(featureType, featureShortLabel, featureFullLabel, () -> ((ObjectAction)managedAction.getAction()).streamFacets());
    }

    public static PrototypingUiModel of(ManagedMember managedMember) {
        Class featureType = managedMember.getElementClass();
        String featureShortLabel = managedMember.getFriendlyName();
        String featureFullLabel = String.format("%s: %s", managedMember.getMemberType(), managedMember.getId());
        return new PrototypingUiModel(featureType, featureShortLabel, featureFullLabel, () -> ((ObjectSpecification)managedMember.getElementType()).streamFacets());
    }

    public Stream<Facet> streamFeatureFacets() {
        return this.facetStreamProvider.get();
    }

    public Class<?> getFeatureType() {
        return this.featureType;
    }

    public String getFeatureFriendlyName() {
        return this.featureFriendlyName;
    }

    public String getFeatureFriendlyIdentifier() {
        return this.featureFriendlyIdentifier;
    }

    public Supplier<Stream<Facet>> getFacetStreamProvider() {
        return this.facetStreamProvider;
    }

    private PrototypingUiModel(Class<?> featureType, String featureFriendlyName, String featureFriendlyIdentifier, Supplier<Stream<Facet>> facetStreamProvider) {
        this.featureType = featureType;
        this.featureFriendlyName = featureFriendlyName;
        this.featureFriendlyIdentifier = featureFriendlyIdentifier;
        this.facetStreamProvider = facetStreamProvider;
    }
}

