/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.decorator.tooltip;

import java.io.Serializable;
import java.util.Optional;
import lombok.NonNull;
import org.springframework.lang.Nullable;

public final class TooltipUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final Optional<String> label;
    @NonNull
    private final String body;

    public static TooltipUiModel ofBody(@NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return TooltipUiModel.of(Optional.empty(), body);
    }

    public static TooltipUiModel of(@Nullable String label, @NonNull String body) {
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        return TooltipUiModel.of(Optional.ofNullable(label), body);
    }

    private TooltipUiModel(@NonNull Optional<String> label, @NonNull String body) {
        if (label == null) {
            throw new NullPointerException("label is marked non-null but is null");
        }
        if (body == null) {
            throw new NullPointerException("body is marked non-null but is null");
        }
        this.label = label;
        this.body = body;
    }

    public static TooltipUiModel of(@NonNull Optional<String> label, @NonNull String body) {
        return new TooltipUiModel(label, body);
    }

    @NonNull
    public Optional<String> getLabel() {
        return this.label;
    }

    @NonNull
    public String getBody() {
        return this.body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TooltipUiModel)) {
            return false;
        }
        TooltipUiModel other = (TooltipUiModel)o;
        Optional<String> this$label = this.getLabel();
        Optional<String> other$label = other.getLabel();
        if (this$label == null ? other$label != null : !((Object)this$label).equals(other$label)) {
            return false;
        }
        String this$body = this.getBody();
        String other$body = other.getBody();
        return !(this$body == null ? other$body != null : !this$body.equals(other$body));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Optional<String> $label = this.getLabel();
        result = result * 59 + ($label == null ? 43 : ((Object)$label).hashCode());
        String $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : $body.hashCode());
        return result;
    }

    public String toString() {
        return "TooltipUiModel(label=" + this.getLabel() + ", body=" + this.getBody() + ")";
    }
}

