/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.feature;

import java.util.Optional;
import org.apache.isis.commons.collections.Can;
import org.apache.isis.core.metamodel.facetapi.FeatureType;
import org.apache.isis.core.metamodel.facets.objectvalue.digits.MaxTotalDigitsFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.fileaccept.FileAcceptFacet;
import org.apache.isis.core.metamodel.facets.objectvalue.typicallen.TypicalLengthFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.ObjectFeature;

public interface ScalarUiModel {
    public ObjectFeature getMetaModel();

    public ManagedObject getOwner();

    default public String getFriendlyName() {
        return this.getMetaModel().getFriendlyName(this::getOwner);
    }

    default public boolean isCollection() {
        return this.getMetaModel().getFeatureType() == FeatureType.ACTION_PARAMETER_COLLECTION || this.getMetaModel().getFeatureType() == FeatureType.COLLECTION;
    }

    default public boolean isScalar() {
        return !this.isCollection();
    }

    default public Optional<String> getDescribedAs() {
        return this.getMetaModel().getDescription(this::getOwner);
    }

    default public Integer getLength() {
        return this.getMetaModel().lookupFacet(MaxTotalDigitsFacet.class).map(MaxTotalDigitsFacet::getMaxTotalDigits).orElse(null);
    }

    default public Integer getTypicalLength() {
        TypicalLengthFacet facet = (TypicalLengthFacet)this.getMetaModel().getFacet(TypicalLengthFacet.class);
        return facet != null ? Integer.valueOf(facet.value()) : null;
    }

    default public String getFileAccept() {
        FileAcceptFacet facet = (FileAcceptFacet)this.getMetaModel().getFacet(FileAcceptFacet.class);
        return facet != null ? (String)facet.value() : null;
    }

    public int getAutoCompleteMinLength();

    public boolean hasChoices();

    public boolean hasAutoComplete();

    public ManagedObject getDefault();

    public Can<ManagedObject> getChoices();

    public Can<ManagedObject> getAutoComplete(String var1);
}

