/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.gridlayout;

import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.NonNull;
import org.apache.isis.applib.layout.component.ActionLayoutData;
import org.apache.isis.applib.layout.component.CollectionLayoutData;
import org.apache.isis.applib.layout.component.DomainObjectLayoutData;
import org.apache.isis.applib.layout.component.FieldSet;
import org.apache.isis.applib.layout.component.PropertyLayoutData;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3ClearFix;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Col;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Grid;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Row;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3RowContent;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3Tab;
import org.apache.isis.applib.layout.grid.bootstrap3.BS3TabGroup;
import org.apache.isis.commons.internal.base._Lazy;
import org.apache.isis.commons.internal.base._NullSafe;
import org.apache.isis.commons.internal.collections._Sets;
import org.apache.isis.core.metamodel.facets.object.grid.GridFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.feature.MixedIn;
import org.apache.isis.core.metamodel.spec.feature.ObjectAction;
import org.apache.isis.core.metamodel.spec.feature.ObjectAssociation;

public class UiGridLayout {
    @NonNull
    private final ManagedObject managedObject;
    private _Lazy<Optional<BS3Grid>> gridData = _Lazy.threadSafe(this::initGridData);

    public <C, T> void visit(Visitor<C, T> visitor) {
        ((Optional)this.gridData.get()).ifPresent(bs3Grid -> {
            for (BS3Row bs3Row : bs3Grid.getRows()) {
                this.visitRow(bs3Row, visitor.rootContainer, visitor);
            }
        });
    }

    private Optional<BS3Grid> initGridData() {
        return this.managedObject.getSpecification().lookupFacet(GridFacet.class).map(gridFacet -> gridFacet.getGrid(this.managedObject)).filter(grid -> grid instanceof BS3Grid).map(BS3Grid.class::cast).map(this::attachAssociatedActions);
    }

    private BS3Grid attachAssociatedActions(BS3Grid bS3Grid) {
        LinkedHashMap primedActions = bS3Grid.getAllActionsById();
        HashSet actionIdsAlreadyAdded = _Sets.newHashSet(primedActions.keySet());
        this.managedObject.getSpecification().streamProperties(MixedIn.INCLUDED).forEach(property -> Optional.ofNullable((PropertyLayoutData)bS3Grid.getAllPropertiesById().get(property.getId())).ifPresent(pl -> ObjectAction.Util.findForAssociation((ManagedObject)this.managedObject, (ObjectAssociation)property).map(action -> action.getId()).filter(id -> !actionIdsAlreadyAdded.contains(id)).peek(actionIdsAlreadyAdded::add).map(ActionLayoutData::new).forEach(pl.getActions()::add)));
        return bS3Grid;
    }

    private <C, T> void visitRow(BS3Row bs3Row, C container, Visitor<C, T> visitor) {
        C uiRow = visitor.newRow(container, bs3Row);
        for (BS3RowContent bs3RowContent : bs3Row.getCols()) {
            if (bs3RowContent instanceof BS3Col) {
                this.visitCol((BS3Col)bs3RowContent, uiRow, visitor);
                continue;
            }
            if (bs3RowContent instanceof BS3ClearFix) {
                visitor.onClearfix(uiRow, (BS3ClearFix)bs3RowContent);
                continue;
            }
            throw new IllegalStateException("Unrecognized implementation of BS3RowContent");
        }
    }

    private <C, T> void visitCol(BS3Col bS3Col, C container, Visitor<C, T> visitor) {
        boolean hasRows;
        C uiCol = visitor.newCol(container, bS3Col);
        boolean hasDomainObject = bS3Col.getDomainObject() != null;
        boolean hasActions = _NullSafe.size((Collection)bS3Col.getActions()) > 0;
        boolean bl = hasRows = _NullSafe.size((Collection)bS3Col.getRows()) > 0;
        if (hasDomainObject || hasActions) {
            C uiActionPanel = visitor.newActionPanel(uiCol);
            if (hasDomainObject) {
                visitor.onObjectTitle(uiActionPanel, bS3Col.getDomainObject());
            }
            if (hasActions) {
                for (ActionLayoutData action : bS3Col.getActions()) {
                    visitor.onAction(uiActionPanel, action);
                }
            }
        }
        for (FieldSet fieldSet : bS3Col.getFieldSets()) {
            this.visitFieldSet(fieldSet, uiCol, visitor);
        }
        for (BS3TabGroup tabGroup : bS3Col.getTabGroups()) {
            this.visitTabGroup(tabGroup, uiCol, visitor);
        }
        if (hasRows) {
            for (BS3Row bs3Row : bS3Col.getRows()) {
                this.visitRow(bs3Row, uiCol, visitor);
            }
        }
        for (CollectionLayoutData collectionData : bS3Col.getCollections()) {
            visitor.onCollection(uiCol, collectionData);
        }
    }

    private <C, T> void visitTabGroup(BS3TabGroup bS3ColTabGroup, C container, Visitor<C, T> visitor) {
        T uiTabGroup = visitor.newTabGroup(container, bS3ColTabGroup);
        for (BS3Tab bs3Tab : bS3ColTabGroup.getTabs()) {
            this.visitTab(bs3Tab, uiTabGroup, visitor);
        }
    }

    private <C, T> void visitTab(BS3Tab bS3Tab, T container, Visitor<C, T> visitor) {
        C uiTab = visitor.newTab(container, bS3Tab);
        for (BS3Row bs3Row : bS3Tab.getRows()) {
            this.visitRow(bs3Row, uiTab, visitor);
        }
    }

    private <C, T> void visitFieldSet(FieldSet cptFieldSet, C container, Visitor<C, T> visitor) {
        C uiFieldSet = visitor.newFieldSet(container, cptFieldSet);
        for (PropertyLayoutData propertyData : cptFieldSet.getProperties()) {
            visitor.onProperty(uiFieldSet, propertyData);
        }
    }

    private UiGridLayout(@NonNull ManagedObject managedObject) {
        if (managedObject == null) {
            throw new NullPointerException("managedObject is marked non-null but is null");
        }
        this.managedObject = managedObject;
    }

    public static UiGridLayout bind(@NonNull ManagedObject managedObject) {
        return new UiGridLayout(managedObject);
    }

    public static abstract class Visitor<C, T> {
        private final C rootContainer;

        protected abstract C newActionPanel(C var1);

        protected abstract C newRow(C var1, BS3Row var2);

        protected abstract C newCol(C var1, BS3Col var2);

        protected abstract T newTabGroup(C var1, BS3TabGroup var2);

        protected abstract C newTab(T var1, BS3Tab var2);

        protected abstract C newFieldSet(C var1, FieldSet var2);

        protected abstract void onObjectTitle(C var1, DomainObjectLayoutData var2);

        protected abstract void onClearfix(C var1, BS3ClearFix var2);

        protected abstract void onAction(C var1, ActionLayoutData var2);

        protected abstract void onProperty(C var1, PropertyLayoutData var2);

        protected abstract void onCollection(C var1, CollectionLayoutData var2);

        public Visitor(C rootContainer) {
            this.rootContainer = rootContainer;
        }
    }
}

