/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.menu;

import java.io.Serializable;
import java.util.List;
import java.util.Locale;
import lombok.NonNull;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.layout.menubars.MenuBars;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBar;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.model.menu.MenuUiModel_buildMenuItems;
import org.apache.isis.viewer.common.model.menu.MenuVisitor;

public class MenuUiModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    @NonNull
    private final DomainServiceLayout.MenuBar menuBarSelect;
    @NonNull
    private final List<String> menuContributingServiceIds;

    public String getCssClass() {
        return this.menuBarSelect.name().toLowerCase(Locale.ENGLISH);
    }

    public void buildMenuItems(IsisAppCommonContext commonContext, MenuVisitor menuBuilder) {
        MenuBars menuBars = commonContext.getMenuBarsService().menuBars();
        BS3MenuBar menuBar = (BS3MenuBar)menuBars.menuBarFor(this.getMenuBarSelect());
        MenuUiModel_buildMenuItems.buildMenuItems(commonContext, menuBar, menuBuilder);
    }

    @NonNull
    public DomainServiceLayout.MenuBar getMenuBarSelect() {
        return this.menuBarSelect;
    }

    @NonNull
    public List<String> getMenuContributingServiceIds() {
        return this.menuContributingServiceIds;
    }

    private MenuUiModel(@NonNull DomainServiceLayout.MenuBar menuBarSelect, @NonNull List<String> menuContributingServiceIds) {
        if (menuBarSelect == null) {
            throw new NullPointerException("menuBarSelect is marked non-null but is null");
        }
        if (menuContributingServiceIds == null) {
            throw new NullPointerException("menuContributingServiceIds is marked non-null but is null");
        }
        this.menuBarSelect = menuBarSelect;
        this.menuContributingServiceIds = menuContributingServiceIds;
    }

    public static MenuUiModel of(@NonNull DomainServiceLayout.MenuBar menuBarSelect, @NonNull List<String> menuContributingServiceIds) {
        return new MenuUiModel(menuBarSelect, menuContributingServiceIds);
    }
}

