/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.menu;

import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.apache.isis.applib.annotation.DomainServiceLayout;
import org.apache.isis.applib.id.HasLogicalType;
import org.apache.isis.core.metamodel.context.MetaModelContext;
import org.apache.isis.core.metamodel.facets.object.domainservicelayout.DomainServiceLayoutFacet;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.viewer.common.model.menu.MenuUiModel;
import org.springframework.stereotype.Service;

@Service
public class MenuUiModelProvider {
    @Inject
    private MetaModelContext metaModelContext;

    public MenuUiModel getMenu(DomainServiceLayout.MenuBar menuBarSelect) {
        return MenuUiModel.of(menuBarSelect, this.select(menuBarSelect));
    }

    private List<String> select(DomainServiceLayout.MenuBar menuBarSelect) {
        return this.metaModelContext.streamServiceAdapters().filter(MenuUiModelProvider.with(menuBarSelect)).map(ManagedObject::getSpecification).map(HasLogicalType::getLogicalTypeName).collect(Collectors.toList());
    }

    private static Predicate<ManagedObject> with(DomainServiceLayout.MenuBar menuBarSelect) {
        return adapter -> {
            DomainServiceLayoutFacet domainServiceLayoutFacet = (DomainServiceLayoutFacet)adapter.getSpecification().getFacet(DomainServiceLayoutFacet.class);
            return domainServiceLayoutFacet != null && domainServiceLayoutFacet.getMenuBar() == menuBarSelect || domainServiceLayoutFacet == null && menuBarSelect == DomainServiceLayout.MenuBar.PRIMARY;
        };
    }
}

