/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.menu;

import java.util.Optional;
import java.util.concurrent.atomic.LongAdder;
import lombok.NonNull;
import org.apache.isis.applib.annotation.Where;
import org.apache.isis.applib.layout.component.ServiceActionLayoutData;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3Menu;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuBar;
import org.apache.isis.applib.layout.menubars.bootstrap3.BS3MenuSection;
import org.apache.isis.commons.internal.base._Strings;
import org.apache.isis.core.metamodel.interactions.managed.ManagedAction;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.runtime.context.IsisAppCommonContext;
import org.apache.isis.viewer.common.applib.services.userprof.UserProfileUiModel;
import org.apache.isis.viewer.common.model.menu.MenuItemDto;
import org.apache.isis.viewer.common.model.menu.MenuVisitor;
import org.apache.isis.viewer.common.model.userprofile.UserProfileUiModelProviderDefault;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

final class MenuUiModel_buildMenuItems {
    private static final Logger log = LogManager.getLogger(MenuUiModel_buildMenuItems.class);

    MenuUiModel_buildMenuItems() {
    }

    public static void buildMenuItems(IsisAppCommonContext commonContext, BS3MenuBar menuBar, MenuVisitor menuBuilder) {
        LongAdder itemsPerSectionCounter = new LongAdder();
        MenuProcessor menuVisitor = MenuProcessor.of(commonContext, menuBuilder);
        for (BS3Menu menu : menuBar.getMenus()) {
            menuVisitor.addTopLevel(menu);
            for (BS3MenuSection menuSection : menu.getSections()) {
                itemsPerSectionCounter.reset();
                for (ServiceActionLayoutData actionLayoutData : menuSection.getServiceActions()) {
                    String serviceBeanName = actionLayoutData.getLogicalTypeName();
                    ManagedObject serviceAdapter = commonContext.lookupServiceAdapterById(serviceBeanName);
                    if (serviceAdapter == null) continue;
                    ManagedAction managedAction = ManagedAction.lookupAction((ManagedObject)serviceAdapter, (String)actionLayoutData.getId(), (Where)Where.EVERYWHERE).orElse(null);
                    if (managedAction == null) {
                        log.warn("No such action: bean-name '{}' action-id '{}'", (Object)serviceBeanName, (Object)actionLayoutData.getId());
                        continue;
                    }
                    Optional visibilityVeto = managedAction.checkVisibility();
                    if (visibilityVeto.isPresent()) continue;
                    boolean isFirstInSection = itemsPerSectionCounter.intValue() == 0;
                    menuVisitor.addSubMenu(menuSection, managedAction, isFirstInSection, actionLayoutData);
                    itemsPerSectionCounter.increment();
                }
            }
        }
    }

    private static MenuItemDto topLevelDto(IsisAppCommonContext commonContext, BS3Menu menu) {
        boolean menuItemIsUserProfile = _Strings.isNullOrEmpty((CharSequence)menu.getNamed());
        String menuItemName = menuItemIsUserProfile ? MenuUiModel_buildMenuItems.userProfileName(commonContext) : menu.getNamed();
        return menuItemIsUserProfile ? MenuItemDto.tertiaryRoot(menuItemName, menu.getCssClassFa()) : MenuItemDto.topLevel(menuItemName, menu.getCssClassFa());
    }

    private static String userProfileName(IsisAppCommonContext commonContext) {
        UserProfileUiModel userProfile = ((UserProfileUiModelProviderDefault)commonContext.lookupServiceElseFail(UserProfileUiModelProviderDefault.class)).userProfile();
        return userProfile.getUserProfileName();
    }

    private static class MenuProcessor {
        private final IsisAppCommonContext commonContext;
        private final MenuVisitor menuVisitor;
        private BS3Menu currentTopLevel;
        private boolean pushedCurrentTopLevel = false;

        public void addTopLevel(BS3Menu menu) {
            this.currentTopLevel = menu;
            this.pushedCurrentTopLevel = false;
        }

        public void addSubMenu(@NonNull BS3MenuSection menuSection, @NonNull ManagedAction managedAction, boolean isFirstInSection, ServiceActionLayoutData actionLayoutData) {
            if (menuSection == null) {
                throw new NullPointerException("menuSection is marked non-null but is null");
            }
            if (managedAction == null) {
                throw new NullPointerException("managedAction is marked non-null but is null");
            }
            if (!this.pushedCurrentTopLevel) {
                MenuItemDto topLevelDto = MenuUiModel_buildMenuItems.topLevelDto(this.commonContext, this.currentTopLevel);
                this.menuVisitor.addTopLevel(topLevelDto);
                this.pushedCurrentTopLevel = true;
                if (isFirstInSection && _Strings.isNotEmpty((CharSequence)menuSection.getNamed())) {
                    this.menuVisitor.addSectionLabel(menuSection.getNamed());
                }
            } else if (isFirstInSection) {
                if (_Strings.isEmpty((CharSequence)menuSection.getNamed())) {
                    this.menuVisitor.addSectionSpacer();
                } else {
                    this.menuVisitor.addSectionSpacer();
                    this.menuVisitor.addSectionLabel(menuSection.getNamed());
                }
            }
            MenuItemDto menuDto = MenuItemDto.subMenu(managedAction, actionLayoutData.getNamed(), actionLayoutData.getCssClassFa());
            this.menuVisitor.addSubMenu(menuDto);
        }

        private MenuProcessor(IsisAppCommonContext commonContext, MenuVisitor menuVisitor) {
            this.commonContext = commonContext;
            this.menuVisitor = menuVisitor;
        }

        public static MenuProcessor of(IsisAppCommonContext commonContext, MenuVisitor menuVisitor) {
            return new MenuProcessor(commonContext, menuVisitor);
        }
    }
}

