/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.object;

import org.apache.isis.applib.annotation.Where;
import org.apache.isis.core.metamodel.commons.ScalarRepresentation;
import org.apache.isis.core.metamodel.consent.InteractionInitiatedBy;
import org.apache.isis.core.metamodel.spec.ManagedObject;
import org.apache.isis.core.metamodel.spec.ManagedObjects;

public interface ObjectUiModel {
    public ManagedObject getManagedObject();

    default public boolean isVisible() {
        return ManagedObjects.VisibilityUtil.isVisible((ManagedObject)this.getManagedObject(), (InteractionInitiatedBy)InteractionInitiatedBy.USER);
    }

    public static interface HasRenderingHints {
        public boolean isInlinePrompt();

        public RenderingHint getRenderingHint();

        @Deprecated
        public void setRenderingHint(RenderingHint var1);

        public ScalarRepresentation getMode();

        @Deprecated
        public void setMode(ScalarRepresentation var1);

        default public boolean isViewMode() {
            return this.getMode() == ScalarRepresentation.VIEWING;
        }

        default public boolean isEditMode() {
            return this.getMode() == ScalarRepresentation.EDITING;
        }

        default public HasRenderingHints toEditMode() {
            this.setMode(ScalarRepresentation.EDITING);
            return this;
        }

        default public HasRenderingHints toViewMode() {
            this.setMode(ScalarRepresentation.VIEWING);
            return this;
        }
    }

    public static enum RenderingHint {
        REGULAR(Where.OBJECT_FORMS),
        PARENTED_PROPERTY_COLUMN(Where.PARENTED_TABLES),
        PARENTED_TITLE_COLUMN(Where.PARENTED_TABLES),
        STANDALONE_PROPERTY_COLUMN(Where.STANDALONE_TABLES),
        STANDALONE_TITLE_COLUMN(Where.STANDALONE_TABLES);

        private final Where where;

        public Where asWhere() {
            return this.where;
        }

        public boolean isRegular() {
            return this == REGULAR;
        }

        public boolean isInParentedTable() {
            return this == PARENTED_PROPERTY_COLUMN;
        }

        public boolean isInStandaloneTable() {
            return this == STANDALONE_PROPERTY_COLUMN;
        }

        public boolean isInTable() {
            return this.isInParentedTable() || this.isInStandaloneTable() || this.isInTableTitleColumn();
        }

        public boolean isInTableTitleColumn() {
            return this.isInParentedTableTitleColumn() || this.isInStandaloneTableTitleColumn();
        }

        public boolean isInParentedTableTitleColumn() {
            return this == PARENTED_TITLE_COLUMN;
        }

        public boolean isInStandaloneTableTitleColumn() {
            return this == STANDALONE_TITLE_COLUMN;
        }

        private RenderingHint(Where where) {
            this.where = where;
        }
    }
}

