/*
 * Decompiled with CFR 0.152.
 */
package org.apache.isis.viewer.common.model.userprofile;

import javax.annotation.Priority;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.isis.applib.services.i18n.TranslationContext;
import org.apache.isis.applib.services.i18n.TranslationService;
import org.apache.isis.applib.services.user.UserMemento;
import org.apache.isis.applib.services.user.UserService;
import org.apache.isis.viewer.common.applib.services.userprof.UserProfileUiModel;
import org.apache.isis.viewer.common.applib.services.userprof.UserProfileUiModelProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service
@Named(value="isis.viewer.common.UserProfileServiceDefault")
@Priority(value=0x5FFFFFFF)
@Qualifier(value="Default")
public class UserProfileUiModelProviderDefault
implements UserProfileUiModelProvider {
    private final UserService userService;
    private final TranslationService translationService;

    @Override
    public UserProfileUiModel userProfile() {
        return UserProfileUiModel.of(this.userProfileName(), this.userService.currentUser().orElse(null));
    }

    private String userProfileName() {
        return this.userService.currentUser().map(this::userNameFor).orElse(String.format("<%s>", this.translated("Anonymous")));
    }

    private String userNameFor(UserMemento x) {
        String username = x.getName();
        if (x.isImpersonating()) {
            return String.format("%s (%s)", username, this.translated("impersonating"));
        }
        String realName = x.getRealName();
        return !UserProfileUiModelProviderDefault.isNullOrEmpty(realName) ? realName : username;
    }

    private String translated(String str) {
        return this.translationService.translate(TranslationContext.forClassName(this.getClass()), str);
    }

    private static boolean isNullOrEmpty(String realName) {
        return realName == null || realName.equals("");
    }

    @Inject
    public UserProfileUiModelProviderDefault(UserService userService, TranslationService translationService) {
        this.userService = userService;
        this.translationService = translationService;
    }
}

